/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.xq.AsyncTools;
import com.af.plugins.xq.DefaultAsyncTools;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import org.json.JSONArray;
import org.json.JSONObject;

public class LogicTools {
    public static void batchRunLogic(JSONArray batchArray, String serviceIP, String serviceName, String servicePort, String logicName) throws Exception {
        LogicTools.batchRunLogic(batchArray, serviceIP, serviceName, servicePort, logicName, null);
    }

    public static void batchRunLogic(JSONArray batchArray, String serviceIP, String serviceName, String servicePort, String logicName, final String callbackUrl) throws Exception {
        AsyncTools asyncTools;
        final int length = batchArray.length();
        final int index = 0;
        Iterator iterator = batchArray.iterator();
        if (servicePort == null) {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            servicePort = objectNames.iterator().next().getKeyProperty("port");
        }
        String url = "http://" + serviceIP + ":" + servicePort + "/" + serviceName + "/rs/logic/async/" + logicName;
        boolean isCallBack = false;
        if (callbackUrl != null) {
            isCallBack = true;
            asyncTools = new AsyncTools(){

                @Override
                public void callBack(Boolean result, String httpCode, String response, String body) {
                    JSONObject progress = new JSONObject();
                    progress.put("currentProgress", index);
                    progress.put("total", length);
                    this.postAsync(callbackUrl, progress, (Boolean)false);
                }
            };
        } else {
            asyncTools = new DefaultAsyncTools();
        }
        while (iterator.hasNext()) {
            Object param = iterator.next();
            if (param instanceof JSONObject) {
                asyncTools.postAsync(url, (JSONObject)param, (Boolean)isCallBack);
                continue;
            }
            asyncTools.postAsync(url, (String)param, (Boolean)isCallBack);
        }
    }
}

