/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.Base64Utils;
import com.af.plugins.DateTools;
import com.af.plugins.sms.PropertiesReaderPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileSaveTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveFileReport(String rootDir, String data, String filename) {
        File dir = new File(rootDir + File.separator + DateTools.getNow("yyyy-MM-dd"));
        FileOutputStream fop = null;
        File file = null;
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            file = new File(dir.getAbsolutePath() + File.separator + DateTools.getNow("yyyy_MM_dd_hh_mm_ss") + filename);
            fop = new FileOutputStream(file);
            byte[] content = Base64Utils.decodeBuffer(data.split(",")[1]);
            fop.write(content);
            fop.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveFileReports(String rootDir, String data, String filename) {
        File dir = new File(rootDir + File.separator + DateTools.getNow("yyyy-MM-dd"));
        FileOutputStream fop = null;
        File file = null;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            file = new File(dir.getAbsolutePath() + File.separator + filename + DateTools.getNow("yyyy_MM_dd_hh_mm_ss"));
            fop = new FileOutputStream(file);
            byte[] content = data.getBytes(StandardCharsets.UTF_8);
            fop.write(content);
            fop.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file.getAbsolutePath();
    }

    public static String getDaiKouData(JSONArray arr, String bankCode) throws Exception {
        ArrayList<String> str = new ArrayList<String>();
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject obj = arr.getJSONObject(i);
            String temp = (String)obj.get("line");
            str.add(temp);
        }
        String name = FileSaveTools.getfileName(bankCode);
        boolean result = FileSaveTools.writeDaikouFile(str, FileSaveTools.getfileName(bankCode));
        if (result) {
            return name;
        }
        return name + "\u6587\u4ef6\u751f\u6210\u5931\u8d25";
    }

    private static String getfileName(String bankCode) {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String date = sdf.format(d);
        return bankCode + date;
    }

    private static boolean writeDaikouFile(List<String> data, String name) throws Exception {
        String path = PropertiesReaderPlugin.read("bank.properties", "DaiKouFilePath");
        File file = new File(path + name + ".txt");
        try {
            BufferedWriter b = new BufferedWriter(new FileWriter(file));
            for (String aData : data) {
                b.write(aData);
                b.newLine();
            }
            b.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getCheckFile(String filename, String encoding) throws Exception {
        String path = PropertiesReaderPlugin.read("bank.properties", "ReturnDaiKouFilePath");
        int ok = 0;
        int fail = 0;
        String result = "error";
        try {
            File file = new File(path + filename + ".txt");
            if (file.isFile() && file.exists()) {
                String lineTxt;
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    result = FileSaveTools.getBeiZhu(lineTxt);
                    if ("ok".equals(result)) {
                        ++ok;
                        continue;
                    }
                    ++fail;
                }
                read.close();
                return DateTools.getNow("yyyy-MM-dd");
            }
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getBeiZhu(String str) {
        String[] arr = str.split("\\|");
        if (arr.length != 7) {
            return "\u6570\u636e\u683c\u5f0f\u6709\u95ee\u9898";
        }
        switch (arr[6]) {
            case "000": {
                return "ok";
            }
            case "999": {
                return "fail";
            }
        }
        return "\u6570\u636e\u9519\u8bef";
    }

    public static String getFileReport(String path) {
        if (path == null || "".equals(path)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try {
            String s;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            while ((s = br.readLine()) != null) {
                result.append(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String getPathFileName(String path) {
        if (path == null || "".equals(path)) {
            return "";
        }
        path = path.replace("\\", "/");
        return path.split("/")[path.split("/").length - 1];
    }

    public static String getPath(String path) {
        if (path == null || "".equals(path)) {
            return "";
        }
        return path.replace("\\", "/");
    }

    public static String deleteFileReport(String path) {
        String result = "error";
        File file = new File(path);
        if (file.exists() && file.delete()) {
            result = "success";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readDaikouFile(String name) throws Exception {
        String str = null;
        String path = PropertiesReaderPlugin.read("bank.properties", "ReturnDaiKouFilePath");
        File file = new File(path + File.separatorChar + name);
        if (!file.exists()) {
            return str;
        }
        BufferedReader bf = null;
        try {
            bf = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            JSONArray all = new JSONArray();
            JSONArray arr = new JSONArray();
            String line0 = null;
            int i = 0;
            while ((str = bf.readLine()) != null) {
                JSONObject job = new JSONObject();
                if ("".equals(str)) continue;
                job.put("line", (Object)str);
                if (0 == i) {
                    line0 = str;
                } else {
                    arr.put((Object)job);
                }
                all.put((Object)job);
                ++i;
            }
            str = "{all:" + all + ",arr:" + arr + ",line0:'" + line0 + "',count:" + i + "}";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFanPanFile(String name, String path) throws Exception {
        String str = null;
        File file = new File(path + File.separatorChar + name);
        if (!file.exists()) {
            return str;
        }
        BufferedReader bf = null;
        try {
            bf = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            JSONArray all = new JSONArray();
            JSONArray arr = new JSONArray();
            String line0 = null;
            int i = 0;
            while ((str = bf.readLine()) != null) {
                JSONObject job = new JSONObject();
                if ("".equals(str)) continue;
                job.put("line", (Object)str);
                if (0 == i) {
                    line0 = str;
                } else {
                    arr.put((Object)job);
                }
                all.put((Object)job);
                ++i;
            }
            str = "{all:" + all + ",arr:" + arr + ",line0:'" + line0 + "',count:" + i + "}";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public static String getQianFeiData(JSONArray arr, String bankCode, String path) throws Exception {
        ArrayList<String> str = new ArrayList<String>();
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject obj = arr.getJSONObject(i);
            String temp = (String)obj.get("line");
            str.add(temp);
        }
        String name = FileSaveTools.getfileName(bankCode);
        try {
            FileUtils.writeLines((File)new File(path + "\\" + name + ".txt"), (String)"GBK", str);
            return name;
        }
        catch (Exception e) {
            return name + "\u6587\u4ef6\u751f\u6210\u5931\u8d25";
        }
    }
}

