/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import com.af.plugins.JsonTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommonTools {
    public static Object getInstance(String className, JSONArray param) {
        Class<?> classInstance;
        try {
            classInstance = Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (param != null && param.length() > 0) {
            Object[] objects = new Object[param.length()];
            Class[] paramClasses = new Class[param.length()];
            for (int i = 0; i < param.length(); ++i) {
                objects[i] = param.get(i);
                Class<?> clazz = objects[i].getClass();
                try {
                    Field f = clazz.getDeclaredField("TYPE");
                    paramClasses[i] = (Class)f.get(null);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    paramClasses[i] = clazz;
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                Constructor<?> constructor = classInstance.getDeclaredConstructor(paramClasses);
                constructor.setAccessible(true);
                return constructor.newInstance(objects);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Constructor<?> constructor = classInstance.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInstance(String className) {
        return CommonTools.getInstance(className, null);
    }

    public static String getUUID(Boolean isSimple) {
        return UUID.fastUUID().toString(isSimple.booleanValue());
    }

    public static String getUUID() {
        return CommonTools.getUUID(false);
    }

    public static String md5(String param) {
        return MD5.create().digestHex(param);
    }

    public static int getRandomNumber(Integer min, Integer max) {
        return RandomUtil.randomInt((int)min, (int)(max + 1));
    }

    public static boolean isNumeric(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static BigDecimal add(Object o1, Object o2) {
        if (o1 instanceof String || o2 instanceof String) {
            return NumberUtil.add((String[])new String[]{String.valueOf(o1), String.valueOf(o2)});
        }
        return NumberUtil.add((Number)((Number)o1), (Number)((Number)o2));
    }

    public static BigDecimal add(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal result = CommonTools.add(o1, o2);
        return result.setScale(scale, RoundingMode.DOWN);
    }

    public static BigDecimal sub(Object o1, Object o2) {
        if (o1 instanceof String || o2 instanceof String) {
            return NumberUtil.sub((String[])new String[]{String.valueOf(o1), String.valueOf(o2)});
        }
        return NumberUtil.sub((Number)((Number)o1), (Number)((Number)o2));
    }

    public static BigDecimal sub(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal result = CommonTools.sub(o1, o2);
        return result.setScale(scale, RoundingMode.DOWN);
    }

    public static BigDecimal mul(Object o1, Object o2) {
        if (o1 instanceof String || o2 instanceof String) {
            return NumberUtil.mul((String)String.valueOf(o1), (String)String.valueOf(o2));
        }
        return NumberUtil.mul((Number)((Number)o1), (Number)((Number)o2));
    }

    public static BigDecimal mul(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal result = CommonTools.mul(o1, o2);
        return result.setScale(scale, RoundingMode.DOWN);
    }

    public static BigDecimal div(Object o1, Object o2) {
        return CommonTools.div(o1, o2, 10);
    }

    public static BigDecimal div(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (o1 instanceof String || o2 instanceof String) {
            return NumberUtil.div((String)String.valueOf(o1), (String)String.valueOf(o2), (int)scale);
        }
        return NumberUtil.div((Number)((Number)o1), (Number)((Number)o2), (int)scale);
    }

    public static JSONArray split(String str, String separator) {
        return new JSONArray((Collection)StrUtil.split((CharSequence)str, (CharSequence)separator));
    }

    public static JSONObject url2json(String urlParams) {
        String[] split;
        JSONObject result = new JSONObject();
        for (String entry : split = urlParams.split("&")) {
            String[] mapEntry = entry.split("=");
            String value = mapEntry.length > 1 ? mapEntry[1] : "";
            result.put(mapEntry[0], (Object)value);
        }
        return result;
    }

    public static boolean isContains(String str, String searchStr) {
        return StrUtil.contains((CharSequence)str, (CharSequence)searchStr);
    }

    public static String union(JSONArray array) {
        StringBuilder result = new StringBuilder();
        array.forEach(item -> result.append("'").append(item).append("',"));
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String union(JSONArray array, String column) {
        StringBuilder result = new StringBuilder();
        array.forEach(item -> {
            JSONObject itemObject = (JSONObject)item;
            result.append("'").append(itemObject.get(column)).append("',");
        });
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static void appendData(JSONArray source, JSONArray target, String key) {
        block0: for (Object sourceItem : source) {
            for (Object targetItem : target) {
                JSONObject sourceItemObj = (JSONObject)sourceItem;
                JSONObject targetItemObj = (JSONObject)targetItem;
                if (!sourceItemObj.get(key).toString().equals(targetItemObj.get(key).toString())) continue;
                JsonTools.addJSON(targetItemObj, sourceItemObj);
                continue block0;
            }
        }
    }

    public static String parametricStr(String str, Map parametricMap) {
        boolean isReplace;
        boolean bl = isReplace = str.contains("{") && str.contains("}");
        if (isReplace) {
            char[] strArray = str.toCharArray();
            StringBuilder replaceStr = new StringBuilder();
            do {
                int start = str.indexOf("{");
                int end = str.indexOf("}");
                for (int i = start + 1; i < end; ++i) {
                    replaceStr.append(strArray[i]);
                }
                String param = String.valueOf(parametricMap.get(replaceStr.toString()));
                if (param.equals("null")) {
                    return str;
                }
                str = str.replace("{" + replaceStr + "}", param);
                replaceStr.setLength(0);
                strArray = str.toCharArray();
                isReplace = start != -1 && end != -1;
            } while (isReplace);
        }
        return str;
    }
}

