package com.af.plugins;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * @author 张振宇
 * @email 809534382@qq.com
 * @createTime 2022年03月04日
 */
public class ToTree {
    static JSONArray jsonArray = new JSONArray("[\n" +
            "  {\n" +
            "    \"id\": \"parent1\",\n" +
            "    \"f_name\": \"智能燃气表\",\n" +
            "    \"f_type_id\": null\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"parent2\",\n" +
            "    \"f_name\": \"智能燃气报警器\",\n" +
            "    \"f_type_id\": null\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"parent37\",\n" +
            "    \"f_name\": \"智能温压监测器\",\n" +
            "    \"f_type_id\": null\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"children1\",\n" +
            "    \"f_name\": \"天信工业商网表\",\n" +
            "    \"f_type_id\": \"parent1\"\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"children2\",\n" +
            "    \"f_name\": \"金卡10网表\",\n" +
            "    \"f_type_id\": \"parent1\"\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"children3\",\n" +
            "    \"f_name\": \"华盛温压监测器\",\n" +
            "    \"f_type_id\": \"parent37\"\n" +
            "  }\n" +
            "]");


//    @Test
    public  void  test() throws Exception {
        System.out.println(listToTree(jsonArray, "id", "f_type_id", "f_name", "children"));
    }

    /**
     * @param arr   数据 [{id,name,parentId},{id,name,parentId}]
     * @param id    自定义组装成功数据的id  默认：id
     * @param pid   自定义组装成功数据的父id  默认：parent_id
     * @param name  自定义组装取值数据  默认：name
     * @param child 自定义子数组的属性名  默认：children
     * @return 一个tree
     * @throws Exception null
     * @tips 每个节点的id需要唯一 如有重复可加标识符如：
     * select 'parent' + cast(id as varchar) id, f_name, null f_type_id
     * from t_iot_device_type
     * union all
     * select 'children' + cast(id as varchar) id, f_brand, 'parent' + cast(isnull(f_type_id, 0) as varchar) f_type_id
     * from t_iot_device_brand;
     */
    public static JSONArray listToTree(JSONArray arr, String id, String pid, String name, String child) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", id);
        jsonObject.put("parent_id", pid);
        jsonObject.put("name", name);
        jsonObject.put("children", child);
        return toTree(arr, jsonObject);
    }

    public static JSONArray listToTree(JSONArray arr) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", "id");
        jsonObject.put("parent_id", "parent_id");
        jsonObject.put("name", "name");
        jsonObject.put("children", "children");
        return toTree(arr, jsonObject);
    }


    public static JSONArray toTree(JSONArray data, JSONObject config) {
        JSONObject childrenListMap = new JSONObject();
        JSONObject nodeIds = new JSONObject();
        JSONArray tree = new JSONArray();
        String c_id = config.optString("id");
        String c_parent_id = config.optString("parent_id");
        String c_name = config.optString("c_name");
        String c_children = config.optString("children");
        for (Object jsonObject : data) {
            String _parentId = ((JSONObject) jsonObject).optString(c_parent_id, "顶层");
            String _id = ((JSONObject) jsonObject).optString(c_id);
            if (!childrenListMap.has(_parentId) && childrenListMap.opt(_parentId) == null) {
                childrenListMap.put(_parentId, new JSONArray());
            }
            nodeIds.put(_id, (JSONObject) jsonObject);
            childrenListMap.getJSONArray(_parentId).put((JSONObject) jsonObject);
        }
        for (Object jsonObject : data) {
            String _parentId = ((JSONObject) jsonObject).optString(c_parent_id);
            if (!nodeIds.has(_parentId) && nodeIds.opt(_parentId) == null) {
                tree.put((JSONObject) jsonObject);
            }
        }
        for (Object obj : tree) {
            adaptToChildrenList((JSONObject) obj, childrenListMap, c_id, c_name, c_children);
        }
        return tree;
    }

    public static void adaptToChildrenList(JSONObject obj, JSONObject childrenListMap, String c_id, String c_name, String c_children) {
        obj.put("label", obj.optString(c_name));
        obj.put("value", obj.optString(c_name));
        if (childrenListMap.has(obj.optString(c_id)) && childrenListMap.optString(obj.optString(c_id)) != null) {
            obj.put(c_children, childrenListMap.getJSONArray(obj.optString(c_id)));
        }
        if (obj.has(c_children) && obj.optJSONArray(c_children) != null) {
            for (Object object : obj.getJSONArray(c_children)) {
                adaptToChildrenList((JSONObject) object, childrenListMap, c_id, c_name, c_children);
            }
        }
    }
}
