package com.af.plugins.calculate;

import java.math.BigDecimal;
import java.text.NumberFormat;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * caption
 * 			单价计算方法。
 * 			费用 = 单价* 数量
 * @author Lyf
 *
 */
public class UnitpriceSettlement implements ISettlementInterface {

	@Override
	public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
		// 单价
		BigDecimal unitprice = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_unitprice")));
		//费用 = 单价* 气量
		BigDecimal chargenum = unitprice.multiply(gas);
		JSONArray array = new JSONArray();
		JSONObject json = new JSONObject();
		json.put("f_price_name", "固定气价");
		json.put("f_price", unitprice);
		json.put("f_gas", gas);
		json.put("f_money", chargenum);
		array.put(json);

		JSONObject ret = new JSONObject();
		ret.put("chargeprice", array);
		ret.put("chargenum", formatNumber(chargenum));
		ret.put("gas", formatNumber(gas));
		ret.put("money", formatNumber(chargenum));
		return ret;
	}

	public static String formatNumber(BigDecimal bigDecimal){
		NumberFormat nf = NumberFormat.getInstance();
		nf.setGroupingUsed(false);
		nf.setMinimumFractionDigits(2);
		nf.setMaximumFractionDigits(4);
		return nf.format(bigDecimal.doubleValue());
	}


	@Override
	public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
		//单价
		BigDecimal unitprice = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_unitprice")));
		BigDecimal amount = fee.divide(unitprice, 2, BigDecimal.ROUND_DOWN);

		JSONArray array = new JSONArray();
		JSONObject json = new JSONObject();
		json.put("f_price_name", "固定气价");
		json.put("f_price", unitprice);
		json.put("f_gas", amount);
		json.put("f_money", fee);
		array.put(json);

		JSONObject ret = new JSONObject();
		ret.put("chargeprice", array);
		ret.put("gas", formatNumber(amount));
		ret.put("money", formatNumber(fee));
		ret.put("chargenum", formatNumber(fee));
		return ret;
	}
}
