package com.af.plugins.sms;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.IOTExceptionCode;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

/**
 * 读取Properties配置文件
 */

public class PropertiesReaderPlugin {

	/**
	 * 根据key获取指定Properties配置文件的值
	 * @param propsName Properties配置文件名
	 * @param key key
	 * @return value
	 */
	public static String read(String propsName, String key) {
		try {
			return read(propsName,key,null);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 根据key获取指定Properties配置文件的值（UTF-8）
	 *
	 * @param propsName Properties配置文件名
	 * @param key key
	 * @return value
	 */
	public static String readToUTF8(String propsName, String key) {
		String s = read(propsName, key);
		return ConvertTools.stringToCharset(s, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8);
	}

	/**
	 * 根据key获取指定Properties配置文件的键值对
	 *
	 * @param propsName Properties配置文件名
	 * @param key key
	 * @return key-value JSON
	 */
	public static JSONObject readTojson(String propsName, String key) {
		String s = read(propsName, key);
		return new JSONObject(ConvertTools.stringToCharset(s, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8));
	}

	/**
	 * 根据key和参数获取指定Properties配置文件的值
	 * @param propsName  文件名
	 * @param key			键值对对应键
	 * @param param   需要加入的参数
	 * @return value
	 */
	public static String read(String propsName, String key, JSONObject param) {
		Properties props = new Properties();
		try {
			props.load(PropertiesReaderPlugin.class.getResourceAsStream("/" + propsName));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		String str = props.getProperty(key);
		if(param != null) {
			Set<String> set =  param.keySet();
			for (String paramStr : set) {
				String replaceString = "{"+paramStr+"}";
				str = str.replace(replaceString, param.getString(paramStr));
			}
		}
		return str;
	}
}
