package com.af.plugins.calculate;

import java.math.BigDecimal;
import java.text.NumberFormat;

import org.json.JSONArray;
import org.json.JSONObject;

public class StairpriceSettlement implements ISettlementInterface {
	@Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
		int length = chargeInfo.length();

		BigDecimal sumamont = chargeInfo.getJSONObject(length - 1)
				.getBigDecimal("sumamount");

		BigDecimal allamount = sumamont.add(gas);

		BigDecimal[] stairPrice = new BigDecimal[length - 1];
		BigDecimal[] stairAmount = new BigDecimal[length - 2];
		BigDecimal[] stairFee = new BigDecimal[length - 1];
		BigDecimal[] stairNum = new BigDecimal[length - 1];
		BigDecimal[] stairSurplus = new BigDecimal[length - 2];

		for (int i = 0; i < length - 1; i++) {
			stairPrice[i] = new BigDecimal(0);
			stairFee[i] = new BigDecimal(0);
			stairNum[i] = new BigDecimal(0);
		}

		for (int i = 0; i < length - 2; i++) {
			stairAmount[i] = new BigDecimal(0);
			stairSurplus[i] = new BigDecimal(0);
		}

		int start = 0;
		int end = 0;
		int i = 0;
		for (; i < length - 2; i++) {
			stairPrice[i] = chargeInfo.getJSONObject(i).getBigDecimal("price");
			stairAmount[i] = chargeInfo.getJSONObject(i)
					.getBigDecimal("amount");

			if (allamount.compareTo(sumamont) > 0) {
				if (sumamont.compareTo(stairAmount[i]) >= 0) {
					start = i + 1;
				}

				if (allamount.compareTo(stairAmount[i]) > 0) {
					end = i + 1;
				}
			} else {
				if (allamount.compareTo(stairAmount[i]) >= 0) {
					start = i + 1;
				}

				if (sumamont.compareTo(stairAmount[i]) > 0) {
					end = i + 1;
				}
			}

		}

		stairPrice[i] = chargeInfo.getJSONObject(i).getBigDecimal("price");

		if (gas.compareTo(BigDecimal.ZERO) > 0) {
			if (start == end) {
				System.out.println("在同一阶梯：" + start);
				stairNum[start] = gas;
				stairFee[start] = gas.multiply(stairPrice[start]).setScale(4,4);
			} else {
				System.out.println("不在同一阶梯：" + start + "--" + end);

				System.out.println("开始阶梯");
				stairNum[start] = stairAmount[start].subtract(sumamont);
				stairFee[start] = stairNum[start].multiply(stairPrice[start])
						.setScale(4, 4);

				for (i = start + 1; i < end; i++) {
					System.out.println("中间阶梯");
					stairNum[i] = stairAmount[i].subtract(stairAmount[(i - 1)]);
					stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(
							4, 4);
				}

				System.out.println("结束阶梯");
				stairNum[end] = allamount.subtract(stairAmount[(end - 1)]);
				stairFee[end] = stairNum[end].multiply(stairPrice[end])
						.setScale(4, 4);
			}
		} else {
			if (start == end) {
				System.out.println("在同一阶梯：" + start);
				stairNum[start] = gas;
				stairFee[start] = gas.multiply(stairPrice[start]);
			} else {
				System.out.println("不在同一阶梯：" + start + "--" + end);

				System.out.println("开始阶梯");
				stairNum[start] = allamount.subtract(stairAmount[start]);
				stairFee[start] = stairNum[start].multiply(stairPrice[start])
						.setScale(4, 4);

				for (i = start + 1; i < end; i++) {
					System.out.println("中间阶梯");
					stairNum[i] = stairAmount[i - 1].subtract(stairAmount[i]);
					stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(
							4, 4);
				}

				System.out.println("结束阶梯");
				stairNum[end] = stairAmount[(end - 1)].subtract(sumamont);
				stairFee[end] = stairNum[end].multiply(stairPrice[end])
						.setScale(4, 4);
			}
		}

		JSONObject ret = new JSONObject();
		BigDecimal chargenum = new BigDecimal(0);
		BigDecimal oughtamount = new BigDecimal(0);

		System.out.println("累购:" + sumamont + "本次购气量:" + gas);

		JSONArray array = new JSONArray();
		for (i = 0; i < length - 1; i++) {
			chargenum = chargenum.add(stairFee[i]);
			oughtamount = oughtamount.add(stairNum[i]);
			ret.put("f_stair" + (i + 1) + "fee", stairFee[i]);
			ret.put("f_stair" + (i + 1) + "amount", stairNum[i]);
			ret.put("f_stair" + (i + 1) + "price", stairPrice[i]);

			JSONObject json = new JSONObject();
			json.put("f_price_name", "阶梯" + (i + 1));
			json.put("f_price", stairPrice[i]);
			json.put("f_gas", stairNum[i]);
			json.put("f_money", stairFee[i]);
			array.put(json);

			System.out.print("阶梯" + (i + 1) + "数量 :" + stairNum[i]);
			System.out.print("阶梯" + (i + 1) + "单价 :" + stairPrice[i]);
			System.out.println("阶梯" + (i + 1) + "金额 :" + stairFee[i]);
		}

		for (i = 0; i < stairAmount.length; i++) {
			ret.put("f_stair" + (i + 1) + "ceiling", stairAmount[i]);

			System.out.println("阶梯" + (i + 1) + "上限 :" + stairAmount[i]);
		}

		for (i = 0; i < length - 2; i++) {
			if (allamount.compareTo(stairAmount[i]) < 0) {
				for (int j = 0; j < i; j++) {
					stairSurplus[j] = BigDecimal.ZERO;
					ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
					System.out.println("阶梯" + (j + 1) + "剩余购气量 :"
							+ stairSurplus[j]);
				}

				stairSurplus[i] = stairAmount[i].subtract(allamount);
				ret.put("f_stair" + (i + 1) + "surplus", stairSurplus[i]);
				System.out
						.println("阶梯" + (i + 1) + "剩余购气量 :" + stairSurplus[i]);

				for (int j = i + 1; j < length - 2; j++) {
					stairSurplus[j] = stairAmount[j]
							.subtract(stairAmount[(j - 1)]);

					ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
					System.out.println("阶梯" + (j + 1) + "剩余购气量 :"
							+ stairSurplus[j]);
				}

				break;
			}
		}
		double chargeNumValue = formatNumber(chargenum);
		ret.put("chargenum", chargeNumValue);
		ret.put("oughtamount", formatNumber(oughtamount));
		ret.put("sumamount", formatNumber(sumamont));
		ret.put("chargeprice", array);
		System.out.println("总金额:" + chargeNumValue);
		return ret;
	}

	public double formatNumber(BigDecimal bigDecimal){
		NumberFormat nf = NumberFormat.getInstance();
		nf.setGroupingUsed(false);
		nf.setMinimumFractionDigits(2);
		nf.setMaximumFractionDigits(8);
		String scoreStr = nf.format(bigDecimal.doubleValue());
		return Double.parseDouble(scoreStr);
	}

	@Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
		int length = chargeInfo.length();

		BigDecimal sumamont = chargeInfo.getJSONObject(length - 1)
				.getBigDecimal("sumamount");
		BigDecimal sumamont1 = chargeInfo.getJSONObject(length - 1)
				.getBigDecimal("sumamount");

		BigDecimal[] stairPrice = new BigDecimal[length - 1];
		BigDecimal[] stairAmount = new BigDecimal[length - 2];
		BigDecimal[] stairFee = new BigDecimal[length - 1];
		BigDecimal[] stairNum = new BigDecimal[length - 1];
		BigDecimal[] stairSurplus = new BigDecimal[length - 2];

		JSONObject ret = new JSONObject();
		BigDecimal chargenum = new BigDecimal(0);
		BigDecimal oughtamount = new BigDecimal(0);

		for (int i = 0; i < length - 1; i++) {
			stairPrice[i] = new BigDecimal(0);
			stairFee[i] = new BigDecimal(0);
			stairNum[i] = new BigDecimal(0);
		}

		for (int i = 0; i < length - 2; i++) {
			stairAmount[i] = new BigDecimal(0);
			stairSurplus[i] = new BigDecimal(0);
		}

		int start = 0;
		int end = 0;
		int i = 0;
		for (; i < length - 2; i++) {
			stairPrice[i] = chargeInfo.getJSONObject(i).getBigDecimal("price");
			stairAmount[i] = chargeInfo.getJSONObject(i)
					.getBigDecimal("amount");

			if (sumamont.compareTo(stairAmount[i]) >= 0) {
				start = i + 1;
			}
		}

		stairPrice[i] = chargeInfo.getJSONObject(i).getBigDecimal("price");

		for (i = start; i < stairAmount.length; i++) {
			if (stairAmount[i].subtract(sumamont).multiply(stairPrice[i])
					.compareTo(fee) >= 0) {
				stairNum[i] = fee.divide(stairPrice[i], 2, 4);

				stairFee[i] = stairNum[i].multiply(stairPrice[i])
						.setScale(4, 4);

				for (int j = 0; j < i; j++) {
					stairSurplus[j] = BigDecimal.ZERO;
					ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
					System.out.println("阶梯" + (j + 1) + "剩余购气量 :"
							+ stairSurplus[j]);
				}

				stairSurplus[i] = stairAmount[i].subtract(stairNum[i])
						.subtract(sumamont);

				ret.put("f_stair" + (i + 1) + "surplus", stairSurplus[i]);
				System.out
						.println("阶梯" + (i + 1) + "剩余购气量 :" + stairSurplus[i]);

				for (int j = i + 1; j < stairAmount.length; j++) {
					stairSurplus[j] = stairAmount[j]
							.subtract(stairAmount[(j - 1)]);

					ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
					System.out.println("阶梯" + (j + 1) + "剩余购气量 :"
							+ stairSurplus[j]);
				}

				break;
			}
			stairNum[i] = stairAmount[i].subtract(sumamont);
			stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(4, 4);

			fee = fee.subtract(stairFee[i]);
			sumamont = stairAmount[i];
		}

		stairNum[i] = fee.divide(stairPrice[i], 2, 4);
		stairFee[i] = fee;

		JSONArray array = new JSONArray();
		for (i = 0; i < length - 1; i++) {
			chargenum = chargenum.add(stairFee[i]);
			oughtamount = oughtamount.add(stairNum[i]);
			ret.put("f_stair" + (i + 1) + "fee", stairFee[i]);
			ret.put("f_stair" + (i + 1) + "amount", stairNum[i]);
			ret.put("f_stair" + (i + 1) + "price", stairPrice[i]);

			JSONObject json = new JSONObject();
			json.put("f_price_name", "阶梯" + (i + 1));
			json.put("f_price", stairPrice[i]);
			json.put("f_gas", stairNum[i]);
			json.put("f_money", stairFee[i]);
			array.put(json);

			System.out.print("阶梯" + i + "数量 :" + stairNum[i]);
			System.out.print("阶梯" + i + "单价 :" + stairPrice[i]);
			System.out.println("阶梯" + i + "金额 :" + stairFee[i]);
		}

		for (i = 0; i < stairAmount.length; i++) {
			ret.put("f_stair" + (i + 1) + "ceiling", stairAmount[i]);

			System.out.println("阶梯" + (i + 1) + "上限 :" + stairAmount[i]);
		}
		int j;
		try {
			ret.get("f_stair1surplus");
		} catch (Exception e) {
			j = 0;
		}
		for (j = 0; j < stairSurplus.length; j++) {
			//stairSurplus[j] = BigDecimal.ZERO;
			ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
			System.out.println("阶梯" + (j + 1) + "剩余购气量 :" + stairSurplus[j]);
		}

		double chargeNumValue = formatNumber(chargenum);
		ret.put("chargenum", chargeNumValue);
		ret.put("sumamount", formatNumber(sumamont1));
		ret.put("gas", formatNumber(oughtamount));
		ret.put("chargeprice", array);
		System.out.println(ret.toString());

		return ret;
	}
}
