package com.af.plugins.calculate;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.NumberFormat;

/**
 * 长安划价插件
 */
public class CAcalculate{
    static Logger log = Logger.getLogger(CAcalculate.class);
    /**
     * @param chargslist 阶梯明细
     * @param type 传入类型
     * @param value 类型值
     * @return
     */
    public JSONObject StairpriceCharge(JSONArray chargslist, String type, BigDecimal value) {
        log.info("阶梯划价走的划价类型是:【" + type+"】");
        int length = chargslist.length();
        //本次气量、金额
        BigDecimal nowamont = new BigDecimal(0);
        BigDecimal nowfee = new BigDecimal(0);
        //累计购气量
        BigDecimal sumamont = chargslist.getJSONObject(length - 1)
                .getBigDecimal("sumamount");
        //累计购气金额
        BigDecimal sumfee = chargslist.getJSONObject(length - 1)
                .getBigDecimal("sumfee");
        //定义阶梯气价
        BigDecimal[] stairPrice = new BigDecimal[length - 1];
        //定义阶梯气量
        BigDecimal[] useAmount = new BigDecimal[length - 1];
        //定义阶梯金额
        BigDecimal[] useFee = new BigDecimal[length - 1];
        //定义阶梯剩余气量
        BigDecimal[] surplusAmount = new BigDecimal[length - 2];
        //定义阶梯最大气量
        BigDecimal[] ceilingAmount = new BigDecimal[length - 2];
        //定义阶梯剩余金额
        BigDecimal[] surplusFee = new BigDecimal[length - 2];
        //本次划价产生气量
        BigDecimal[] stairAmount = new BigDecimal[length - 1];
        //本次划价产生金额
        BigDecimal[] stairFee = new BigDecimal[length - 1];
        //初始用气量、金额赋值
        for (int i = 0; i < length - 1; i++) {
            //阶梯气价赋值
            stairPrice[i] = chargslist.getJSONObject(i).getBigDecimal("f_price");
            //阶梯气量赋值
            useAmount[i] = chargslist.getJSONObject(i).getBigDecimal("f_gas");
            //阶梯费用赋值
            useFee[i] = chargslist.getJSONObject(i).getBigDecimal("f_money");
            //本次划价气量金额暂时赋为0
            stairAmount[i] = new BigDecimal(0);
            stairFee[i] = new BigDecimal(0);
        }
        //初始剩余气量、金额赋值
        for (int i = 0; i < length - 2; i++) {
            if(i==0){
                surplusAmount[i] = chargslist.getJSONObject(i).getBigDecimal("f_amount").subtract(useAmount[i]);
                surplusFee[i] = surplusAmount[i].multiply(stairPrice[i]);
                ceilingAmount[i] = chargslist.getJSONObject(i).getBigDecimal("f_amount");
            }else {
                surplusAmount[i] = chargslist.getJSONObject(i).getBigDecimal("f_amount").subtract(chargslist.getJSONObject(i-1).getBigDecimal("f_amount")).subtract(useAmount[i]);
                surplusFee[i] = surplusAmount[i].multiply(stairPrice[i]);
                ceilingAmount[i] = chargslist.getJSONObject(i).getBigDecimal("f_amount");
            }
        }
        int i = 0;
        //运算前赋值
        BigDecimal calculationvalue=value;
        //划价数据大于0
        if (calculationvalue.compareTo(BigDecimal.ZERO) > 0) {
            if(type.equals("气量")){
                for (i = 0; i < length - 1; i++) {
                    //如果属于最高阶梯
                    if(i==length - 2){
                        stairAmount[i]=calculationvalue;
                        stairFee[i]=calculationvalue.multiply(stairPrice[i]);
                        calculationvalue=BigDecimal.ZERO;
                    }
                    //如果剩余气量减置为0
                    if (calculationvalue.compareTo(BigDecimal.ZERO) <= 0) {
                        //直接跳出
                        break;
                    }
                    //如果剩余气量大于当阶梯剩余
                    if(calculationvalue.compareTo(surplusAmount[i])>0){
                        //阶梯划价赋值
                        stairAmount[i]=surplusAmount[i];
                        stairFee[i]=surplusFee[i];
                        calculationvalue=calculationvalue.subtract(surplusAmount[i]);
                    }else {
                        //阶梯划价赋值
                        stairAmount[i]=calculationvalue;
                        stairFee[i]=calculationvalue.multiply(stairPrice[i]);
                        //剩余扣减置为0
                        calculationvalue=BigDecimal.ZERO;
                    }
                }
            }else {
                for (i = 0; i < length - 1; i++) {
                    //如果属于最高阶梯
                    if(i==length - 2){
                        stairFee[i]=calculationvalue;
                        stairAmount[i]=calculationvalue.divide(stairPrice[i], 2, 4);
                        calculationvalue=BigDecimal.ZERO;
                    }
                    //如果剩余金额减置为0
                    if (calculationvalue.compareTo(BigDecimal.ZERO) <= 0) {
                        //直接跳出
                        break;
                    }
                    //如果剩余金额大于（剩余气量*金额）
                    if(calculationvalue.compareTo(surplusAmount[i].multiply(stairPrice[i]))>0){
                        //阶梯划价赋值
                        stairAmount[i]=surplusAmount[i];
                        stairFee[i]=surplusFee[i];
                        calculationvalue=calculationvalue.subtract(surplusFee[i]);
                    }else {
                        //阶梯划价赋值
                        stairFee[i]=calculationvalue;
                        stairAmount[i]=calculationvalue.divide(stairPrice[i], 2, 4);
                        //剩余扣减置为0
                        calculationvalue=BigDecimal.ZERO;
                    }
                }
            }

        }
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        for (i = 0; i < length - 1; i++) {
            if(stairAmount[i].compareTo(BigDecimal.ZERO) > 0){
                //盈余减去本次划价
                //只有非最高阶才存在结余
                if(i!=length - 2){
                    surplusAmount[i]=surplusAmount[i].subtract(stairAmount[i]);
                    surplusFee[i]=surplusFee[i].subtract(stairFee[i]);
                }
                //用量加上本次划价
                useAmount[i]=useAmount[i].add(stairAmount[i]);
                useFee[i]=useFee[i].add(stairFee[i]);
                sumfee=sumfee.add(stairFee[i]);
                sumamont=sumamont.add(stairAmount[i]);
                nowamont=nowamont.add(stairAmount[i]);
                nowfee=nowfee.add(stairFee[i]);
            }
        }
        for (i = 0; i < length - 2; i++) {
            result.put("f_surplus" + (i + 1) + "amount", surplusAmount[i]);
            result.put("f_stair" + (i + 1) + "ceiling", ceilingAmount[i]);
            result.put("f_surplus" + (i + 1) + "fee", surplusFee[i]);
        }
        for (i = 0; i < length - 1; i++) {
            result.put("f_stair" + (i + 1) + "price", stairPrice[i]);
            result.put("f_use" + (i + 1) + "amount", useAmount[i]);
            result.put("f_use" + (i + 1) + "fee", useFee[i]);
            JSONObject json = new JSONObject();
            json.put("f_price_name", "阶梯" + (i + 1));
            json.put("f_price", stairPrice[i]);
            json.put("f_gas", stairAmount[i]);
            json.put("f_money", stairFee[i]);
            json.put("f_level", (i + 1));
            array.put(json);
        }
        //累计购气金额
        result.put("sumamount", formatNumber(sumamont));
        result.put("sumfee", formatNumber(sumfee));
        result.put("nowamont", formatNumber(nowamont));
        result.put("nowfee", formatNumber(nowfee));
        result.put("chargeprice", array);
        return result;
    }
    public double formatNumber(BigDecimal bigDecimal){
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(8);
        String scoreStr = nf.format(bigDecimal.doubleValue());
        return Double.parseDouble(scoreStr);
    }

    /**
     * 固定气价按气量
     * @param chargeInfo
     * @param gas
     * @return
     */
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        // 单价
        BigDecimal unitprice = chargeInfo.getJSONObject(0).getBigDecimal("f_unitprice");
        //费用 = 单价* 气量
        BigDecimal chargenum = unitprice.multiply(gas);
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", "固定气价");
        json.put("f_price", unitprice);
        json.put("f_gas", gas);
        json.put("f_level", 1);
        json.put("f_money", chargenum);
        array.put(json);
        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("nowamont", formatNumber(gas));
        ret.put("nowfee", formatNumber(chargenum));
        System.out.println(ret.toString());
        return ret;
    }

    /**
     * 固定气价按金额
     * @param chargeInfo
     * @param fee
     * @return
     */
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        //单价
        BigDecimal unitprice = chargeInfo.getJSONObject(0).getBigDecimal("f_unitprice");
        BigDecimal amount = fee.divide(unitprice, 2, BigDecimal.ROUND_DOWN);

        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", "固定气价");
        json.put("f_price", unitprice);
        json.put("f_level", 1);
        json.put("f_gas", amount);
        json.put("f_money", fee);
        array.put(json);

        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("nowamont", formatNumber(amount));
        ret.put("nowfee", formatNumber(fee));
        System.out.println(ret.toString());
        return ret;
    }
}
