package com.af.plugins;

import com.af.plugins.sms.PropertiesReaderPlugin;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 保存文件
 *
 * @author zhaotong
 *
 */
public class FileSaveTools {
	// 保存文件
	public static String saveFileReport(String rootDir, String data, String filename) {
		File dir = new File(rootDir + File.separator + DateTools.getNow("yyyy-MM-dd"));
		FileOutputStream fop = null;
		File file = null;
		if (!dir.exists()) {
			dir.mkdir();
		}
		try {
			file = new File(dir.getAbsolutePath() + File.separator + DateTools.getNow("yyyy_MM_dd_hh_mm_ss") + filename);
			fop = new FileOutputStream(file);
			byte[] content = Base64Utils.decodeBuffer(data.split(",")[1]);
			fop.write(content);
			fop.flush();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if (fop != null) {
					fop.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		return file.getAbsolutePath();
	}

	// 保存文件
	public static String saveFileReports(String rootDir, String data, String filename) {
		File dir = new File(rootDir + File.separator + DateTools.getNow("yyyy-MM-dd"));
			FileOutputStream fop = null;
			File file = null;
			if (!dir.exists()) {
				dir.mkdirs();
			}
			try {
				file = new File(dir.getAbsolutePath() + File.separator + filename + DateTools.getNow("yyyy_MM_dd_hh_mm_ss"));
				fop = new FileOutputStream(file);
				//BASE64Decoder decoder = new BASE64Decoder();
				byte[] content = data.getBytes(StandardCharsets.UTF_8);
				//byte[] content = decoder.decodeBuffer(data.split(",")[1]);
				fop.write(content);
				fop.flush();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					if (fop != null) {
						fop.close();
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
			}

			return file.getAbsolutePath();
		}

	/**
	 *
	 * @param arr
	 *            业务逻辑层传过来的代扣文件记录
	 * @param bankCode
	 *            业务逻辑层传过来的银行代码
	 * @return 生成的银行代扣文件名（失败则返回该文件生成失败）
	 * @throws Exception 异常
	 */
	public static String getDaiKouData(JSONArray arr, String bankCode) throws Exception {
		List<String> str = new ArrayList<String>();
		for (int i = 0; i < arr.length(); i++) {
			JSONObject obj = arr.getJSONObject(i);
			String temp = (String) obj.get("line");
			str.add(temp);
		}
		String name = getfileName(bankCode);
		boolean result = writeDaikouFile(str, getfileName(bankCode));
		if (result) {
			return name;
		} else {
			return name + "文件生成失败";
		}

	}

	/**
	 *
	 * @param bankCode
	 *            银行代码
	 * @return bankCode+date 根据银行代码和日期生成的代扣文件名
	 */
	private static String getfileName(String bankCode) {
		Date d = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
		String date = sdf.format(d);
		return bankCode + date;

	}

	/**
	 *
	 * @param data
	 *            代扣文件记录
	 * @param name
	 *            代扣文件名
	 * @return result 代扣文件是否生成，true（成功），false（失败）
	 * @throws Exception
	 */
	private static boolean writeDaikouFile(List<String> data, String name) throws Exception {
		// 从属性文件读取银行代扣文件的存储位置
		String path = PropertiesReaderPlugin.read("bank.properties", "DaiKouFilePath");
		// 代扣文件生成的地址
		File file = new File(path + name + ".txt");
		BufferedWriter b;
		try {
			b = new BufferedWriter(new FileWriter(file));
			for (String aData : data) {
				b.write(aData);
				b.newLine();
			}
			b.close();
			return true;

		} catch (IOException e) {

			e.printStackTrace();
		}

		return false;
	}

	/**
	 *
	 * @param filename
	 *            银行发送的代扣文件名
	 * @param encoding
	 *            编码格式
	 * @return String 当前操作日期
	 * @throws Exception 异常
	 */
	public static String getCheckFile(String filename, String encoding) throws Exception {
		//从属性文件读取银行代扣文件的存储位置
		String path = PropertiesReaderPlugin.read("bank.properties", "ReturnDaiKouFilePath");
		//代扣记录成功的条数，如果有需要可返回给业务逻辑层
		int ok = 0;
		//代扣记录失败的条数，如果有需要可返回给业务逻辑层
		int fail = 0;
		String result = "error";
		try {
			File file = new File(path + filename + ".txt");
			//判断文件是否存在
			if (file.isFile() && file.exists()) {
				//注意编码格式
				InputStreamReader read = new InputStreamReader(
						new FileInputStream(file), encoding);
				BufferedReader bufferedReader = new BufferedReader(read);
				String lineTxt;
				while ((lineTxt = bufferedReader.readLine()) != null) {

					result = getBeiZhu(lineTxt);
					if ("ok".equals(result)) {
						ok++;
					} else {
						fail++;
					}
				}
				read.close();
				return DateTools.getNow("yyyy-MM-dd");
			} else {
				System.out.println("文件不存在");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;

	}

	/**
	 *
	 * @param str
	 *            银行代扣文件的记录
	 * @return String 返回备注中是否代扣成功
	 *
	 */
	private static String getBeiZhu(String str) {
		String[] arr = str.split("\\|");
		if (arr.length != 7) {
			return "数据格式有问题";
		}
		switch (arr[6]) {
			case "000":
				return "ok";
			case "999":
				return "fail";
			default:
				return "数据错误";
		}

	}

	public static String getFileReport(String path) {
		if (path == null || "".equals(path)) {
			return "";
		}
		StringBuilder result = new StringBuilder();
		try {
			//构造一个BufferedReader类来读取文件
			BufferedReader br = new BufferedReader(new InputStreamReader(
					new FileInputStream(path), StandardCharsets.UTF_8));
			String s;
			//使用readLine方法，一次读一行
			while ((s = br.readLine()) != null) {
				result.append(s);
			}
			br.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result.toString();
	}

	public static String getPathFileName(String path) {
		if (path == null || "".equals(path)) {
			return "";
		}
		path = path.replace("\\", "/");
		return path.split("/")[path.split("/").length - 1];
	}

	public static String getPath(String path) {
		if (path == null || "".equals(path)) {
			return "";
		}
		return path.replace("\\", "/");
	}

	public static String deleteFileReport(String path) {
		String result = "error";
		File file = new File(path);
		if (file.exists()) {
			if (file.delete()) {
				result = "success";
			}
		}
		return result;
	}

	public static String readDaikouFile(String name) throws Exception {
		String str = null;
		// 从属性文件读取银行代扣文件的存储位置
		String path = PropertiesReaderPlugin.read("bank.properties", "ReturnDaiKouFilePath");
//		String path = "E:\\奥枫\\新产品\\签约\\";

		File file = new File(path + File.separatorChar + name);
		if (!file.exists()) {
            return str;
        }
		BufferedReader bf = null;
		try {
			bf = new BufferedReader(new InputStreamReader(
	                new FileInputStream(file)));
			JSONArray all = new JSONArray();
			JSONArray arr = new JSONArray();
			String line0 = null;
			int i = 0;
			while ((str = bf.readLine()) != null) {
				JSONObject job = new JSONObject();
				if (!"".equals(str)) {
					job.put("line", str);
					if (0 == i) {
                        line0 = str;
                    } else {
                        arr.put(job);
                    }
					all.put(job);
					i++;
				}
			}
			str = "{all:" + all + ",arr:" + arr + ",line0:'" + line0
					+ "',count:" + i + "}";
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (bf != null) {
					bf.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return str;
	}
}
