/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.onenet;

import com.af.plugins.ConvertTools;
import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.IOTExceptionCode;
import com.af.plugins.iot.WebMeterInfo;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONObject;

public class OnenetTools {
    public static JSONObject decodeCallBackData(String encodeStr) {
        byte[] plain_msg;
        byte[] aes_msg = ConvertTools.base64Decode(encodeStr.getBytes(StandardCharsets.UTF_8));
        byte[] password = ConvertTools.base64Decode((WebMeterInfo.getString("onenetEncodingAESKey") + "=").getBytes(StandardCharsets.UTF_8));
        try {
            plain_msg = OnenetTools.decrypt(aes_msg, password);
        }
        catch (Exception e) {
            throw new IOTException(IOTExceptionCode.ONENET_DECODE_CALLBACK_FAIL);
        }
        String str = new String(plain_msg, StandardCharsets.UTF_8);
        return new JSONObject(str.substring(str.indexOf("{")));
    }

    private static byte[] decrypt(byte[] encrypted, byte[] password) throws Exception {
        byte[] bs = new byte[16];
        System.arraycopy(password, 0, bs, 0, 16);
        IvParameterSpec zeroIv = new IvParameterSpec(bs);
        SecretKeySpec key = new SecretKeySpec(password, "AES");
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        cipher.init(2, (Key)key, zeroIv);
        return cipher.doFinal(encrypted);
    }
}

