/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.iot;

import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.IOTExceptionCode;
import com.af.plugins.sms.PropertiesReaderPlugin;
import com.aote.module.ModuleMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class WebMeterInfo {
    private static Map<String, JSONObject> propertiesMap;
    private static ThreadLocal<String> moduleName;

    public static Map<String, JSONObject> getPropertiesMap() {
        return propertiesMap;
    }

    public static String getString(String key) {
        return propertiesMap.get(moduleName.get()).getString(key);
    }

    public static String getString(String key, JSONObject params) {
        String valueStr = propertiesMap.get(WebMeterInfo.getModuleName()).getString(key);
        Set set = params.keySet();
        for (String paramStr : set) {
            String replaceString = "\\{" + paramStr + "}";
            if (!"null".equals(params.getString(paramStr))) {
                valueStr = valueStr.replaceAll(replaceString, params.getString(paramStr));
                continue;
            }
            try {
                valueStr = valueStr.replaceAll(replaceString, WebMeterInfo.getString(paramStr));
            }
            catch (JSONException e) {
                valueStr = valueStr.replaceAll(replaceString, "null");
            }
        }
        return valueStr;
    }

    public static void setModuleName(String name) {
        if (!propertiesMap.containsKey(name)) {
            throw new IOTException(IOTExceptionCode.MODULE_NOT_FIND_FAIL);
        }
        moduleName.set(name);
    }

    public static String getModuleName() {
        return moduleName.get();
    }

    public static void removeModuleName() {
        moduleName.remove();
    }

    static {
        moduleName = new ThreadLocal();
        propertiesMap = new HashMap<String, JSONObject>();
        Map map = ModuleMapper.getMap();
        for (String moduleName : map.keySet()) {
            String config = PropertiesReaderPlugin.readWebMeter(null, moduleName, null);
            if (config == null) continue;
            JSONObject params = new JSONObject(config);
            propertiesMap.put(moduleName, params);
        }
    }
}

