/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.iot;

import com.af.plugins.DateTools;
import com.af.plugins.iot.AuthenticationTools;
import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.NorthApiClientTools;
import com.af.plugins.iot.NotifyType;
import com.af.plugins.iot.WebMeterInfo;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.iotplatform.client.NorthApiClient;
import com.huawei.iotplatform.client.NorthApiException;
import com.huawei.iotplatform.client.dto.AsynCommandDTO;
import com.huawei.iotplatform.client.dto.DeviceCommand;
import com.huawei.iotplatform.client.dto.PostDeviceCommandInDTO;
import com.huawei.iotplatform.client.dto.PostDeviceCommandOutDTO;
import com.huawei.iotplatform.client.dto.QueryDeviceCommandInDTO;
import com.huawei.iotplatform.client.dto.QueryDeviceCommandOutDTO;
import com.huawei.iotplatform.client.invokeapi.SignalDelivery;
import com.huawei.iotplatform.utils.JsonUtil;
import java.util.HashMap;
import org.apache.http.entity.ContentType;
import org.json.JSONArray;
import org.json.JSONObject;

public class SignalDeliveryTools {
    public static JSONArray getCommandStatus(String deviceId) {
        QueryDeviceCommandOutDTO qdcod;
        SignalDelivery sd = new SignalDelivery();
        sd.setNorthApiClient(NorthApiClientTools.getNorthApiClient());
        QueryDeviceCommandInDTO qdcid = new QueryDeviceCommandInDTO();
        qdcid.setDeviceId(deviceId);
        qdcid.setPageNo(Integer.valueOf(0));
        qdcid.setPageSize(Integer.valueOf(150));
        qdcid.setStartTime(DateTools.getDiffDate("DATE", "-2", "yyyyMMdd'T'000000'Z'"));
        try {
            qdcod = sd.queryDeviceCommand(qdcid, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
        JSONArray result = new JSONArray();
        for (DeviceCommand command : qdcod.getData()) {
            JSONObject item = new JSONObject();
            item.put("commandId", (Object)command.getCommandId());
            item.put("status", (Object)command.getStatus());
            result.put((Object)item);
        }
        return result;
    }

    public static JSONObject postCommand(String serviceId, String method, String deviceId, JSONObject jo) {
        PostDeviceCommandOutDTO pdcod;
        SignalDelivery sd = new SignalDelivery();
        sd.setNorthApiClient(NorthApiClientTools.getNorthApiClient());
        PostDeviceCommandInDTO pdcid = new PostDeviceCommandInDTO();
        pdcid.setDeviceId(deviceId);
        AsynCommandDTO acdo = new AsynCommandDTO();
        ObjectNode paras = null;
        try {
            paras = JsonUtil.convertObject2ObjectNode((Object)jo.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        acdo.setServiceId(serviceId);
        acdo.setMethod(method);
        acdo.setParas(paras);
        pdcid.setCommand(acdo);
        pdcid.setExpireTime(Integer.valueOf(0));
        pdcid.setCallbackUrl(WebMeterInfo.getString("telecomCallBackUrl"));
        try {
            pdcod = sd.postDeviceCommand(pdcid, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
        JSONObject object = new JSONObject();
        object.put("commandId", (Object)pdcod.getCommandId());
        object.put("appId", (Object)pdcod.getAppId());
        object.put("deviceId", (Object)pdcod.getDeviceId());
        object.put("callbackUrl", (Object)pdcod.getCallbackUrl());
        object.put("status", (Object)pdcod.getStatus());
        object.put("result", (Object)pdcod.getResult());
        return object;
    }

    public static JSONObject postCommand(String method, String deviceId, String base64String) {
        JSONObject object = new JSONObject();
        object.put("rawData", (Object)base64String);
        return SignalDeliveryTools.postCommand("RawData", method, deviceId, object);
    }

    public static JSONObject subscribe(NotifyType notifyType, String callBackUrl) {
        String accessToken = AuthenticationTools.getAuthToken();
        NorthApiClient northApiClient = NorthApiClientTools.getNorthApiClient();
        String regDeviceUrl = "https://" + northApiClient.getClientInfo().getPlatformIp() + ":" + northApiClient.getClientInfo().getPlatformPort() + "/iocm/app/sub/v1.2.0/subscriptions";
        HashMap<String, String> header = new HashMap<String, String>(16);
        header.put("app_key", WebMeterInfo.getString("telecomAPIKey"));
        header.put("Authorization", "Bearer " + accessToken);
        JSONObject bodyParams = new JSONObject();
        bodyParams.put("notifyType", (Object)notifyType.getValue());
        bodyParams.put("callbackUrl", (Object)callBackUrl);
        try {
            return (JSONObject)northApiClient.invokeAPI(regDeviceUrl, "POST", null, bodyParams.toString(), header, null, null, ContentType.APPLICATION_JSON, null, JSONObject.class);
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
    }

    public static JSONObject deleteAllSubscribe() {
        String accessToken = AuthenticationTools.getAuthToken();
        NorthApiClient northApiClient = NorthApiClientTools.getNorthApiClient();
        String regDeviceUrl = "https://" + northApiClient.getClientInfo().getPlatformIp() + ":" + northApiClient.getClientInfo().getPlatformPort() + "/iocm/app/sub/v1.2.0/subscriptions";
        HashMap<String, String> header = new HashMap<String, String>(16);
        header.put("app_key", WebMeterInfo.getString("telecomAPIKey"));
        header.put("Authorization", "Bearer " + accessToken);
        try {
            return (JSONObject)northApiClient.invokeAPI(regDeviceUrl, "DELETE", null, null, header, null, null, ContentType.APPLICATION_JSON, null, JSONObject.class);
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
    }
}

