/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.iot;

import com.af.plugins.iot.AuthenticationTools;
import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.NorthApiClientTools;
import com.af.plugins.iot.WebMeterInfo;
import com.huawei.iotplatform.client.NorthApiException;
import com.huawei.iotplatform.client.dto.ModifyDeviceInfoInDTO;
import com.huawei.iotplatform.client.dto.QueryDeviceStatusOutDTO;
import com.huawei.iotplatform.client.dto.RegDirectDeviceInDTO;
import com.huawei.iotplatform.client.dto.RegDirectDeviceOutDTO;
import com.huawei.iotplatform.client.invokeapi.DeviceManagement;

public class DeviceManagementTools {
    public String regDevice(String nodeId) {
        RegDirectDeviceOutDTO rddod;
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        RegDirectDeviceInDTO rddid = new RegDirectDeviceInDTO();
        rddid.setNodeId(nodeId);
        rddid.setVerifyCode(nodeId);
        rddid.setTimeout(Integer.valueOf(0));
        try {
            String authToken = AuthenticationTools.getAuthToken();
            rddod = dm.regDirectDevice(rddid, WebMeterInfo.getString("telecomAPIKey"), authToken);
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
        return rddod.getDeviceId();
    }

    public int modifyDeviceInfo(String deviceId, String name) {
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        ModifyDeviceInfoInDTO mdiid = new ModifyDeviceInfoInDTO();
        mdiid.setName(name);
        mdiid.setDeviceId(deviceId);
        mdiid.setManufacturerId(WebMeterInfo.getString("manuFacturerId"));
        mdiid.setManufacturerName(WebMeterInfo.getString("manuFacturerName"));
        mdiid.setDeviceType(WebMeterInfo.getString("deviceType"));
        mdiid.setModel(WebMeterInfo.getString("meterModel"));
        mdiid.setProtocolType("CoAP");
        try {
            dm.modifyDeviceInfo(mdiid, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            return 0;
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
    }

    public int cancelDevice(String device_id) {
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        try {
            String authToken = AuthenticationTools.getAuthToken();
            dm.deleteDirectDevice(device_id, WebMeterInfo.getString("telecomAPIKey"), authToken);
            return 0;
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
    }

    public int queryDeviceStatus(String deviceId) {
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        try {
            QueryDeviceStatusOutDTO qdsod = dm.queryDeviceStatus(deviceId, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            return 0;
        }
        catch (NorthApiException e) {
            throw new IOTException(e);
        }
    }
}

