/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.iot;

import com.af.plugins.iot.IOTException;
import com.af.plugins.iot.IOTExceptionCode;
import com.af.plugins.iot.NorthApiClientTools;
import com.huawei.iotplatform.client.NorthApiException;
import com.huawei.iotplatform.client.dto.AuthOutDTO;
import com.huawei.iotplatform.client.invokeapi.Authentication;

public class AuthenticationTools {
    private static ThreadLocal<Long> stamp = new ThreadLocal();
    private static ThreadLocal<AuthOutDTO> aod = new ThreadLocal();

    public static String getAuthToken() {
        long current = System.currentTimeMillis();
        if (aod.get() != null && current - stamp.get() < 900000L) {
            return aod.get().getAccessToken();
        }
        try {
            Authentication auth = new Authentication(NorthApiClientTools.getNorthApiClient());
            aod.set(auth.getAuthToken());
            stamp.set(System.currentTimeMillis());
            return aod.get().getAccessToken();
        }
        catch (NorthApiException e) {
            throw new IOTException(IOTExceptionCode.AUTHENTICATION_FAIL);
        }
    }

    public static void logout() {
        stamp.remove();
        aod.remove();
    }

    static {
        stamp.set(System.currentTimeMillis());
    }
}

