/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.HttpDeleteWithBody;
import com.af.plugins.UrlTools;
import com.aote.ThreadResource;
import com.aote.rs.mapper.WebException;
import com.aote.transaction.SessionPool;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RestTools {
    public static String request(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base) {
        if (!path.startsWith("http")) {
            path = UrlTools.getUrl(path);
        }
        base.setURI(URI.create(path));
        if (value != null && !"".equals(value)) {
            StringEntity se = new StringEntity(value, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
        RestTools.setHeaders(headersStr, base);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)base);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            String data = response.getStatusLine().getReasonPhrase();
            return "{status: " + code + ", data: '" + data + "'}";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpEntity requestPostFile(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base) {
        if (!path.startsWith("http")) {
            path = UrlTools.getUrl(path);
        }
        base.setURI(URI.create(path));
        if (value != null && !"".equals(value)) {
            StringEntity se = new StringEntity(value, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
        RestTools.setHeaders(headersStr, base);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)base);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return response.getEntity();
            }
            throw new WebException(code, "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setHeaders(String headersStr, HttpEntityEnclosingRequestBase base) {
        String token = (String)ThreadResource.Token.get();
        if (token != null) {
            base.setHeader("Token", token);
        }
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = headers.getString(key);
                base.setHeader(key, val);
            }
        }
    }

    public static String post(String path) {
        return RestTools.post(path, null, null);
    }

    public static String post(String path, JSONObject value) {
        return RestTools.post(path, value, null);
    }

    public static HttpEntity postHttpEntity(String path, JSONObject value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools.requestPostFile(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String post(String path, String value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools.request(path, value, headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String post(String path, JSONObject value, JSONObject headers) {
        if (value != null) {
            if (headers == null) {
                headers = new JSONObject();
            }
            headers.put("Content-Type", (Object)"application/json");
            return RestTools.request(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
        }
        if (headers == null) {
            return RestTools.request(path, "", "", (HttpEntityEnclosingRequestBase)new HttpPost());
        }
        return RestTools.request(path, "", headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String get(String path) {
        return RestTools.get(path, null);
    }

    public static String get(String path, JSONObject headers) {
        try {
            CloseableHttpClient httpClient;
            HttpResponse response;
            int code;
            if (!path.startsWith("http")) {
                path = UrlTools.getUrl(path);
            }
            HttpGet getMethod = new HttpGet(path);
            if (headers != null) {
                Iterator keys = headers.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = headers.getString(key);
                    getMethod.setHeader(key, val);
                }
            }
            if ((code = (response = (httpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)getMethod)).getStatusLine().getStatusCode()) == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            String data = response.getStatusLine().getReasonPhrase();
            return "{status: " + code + ", data: '" + data + "'}";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBytesForPost(String path) {
        try {
            path = UrlTools.getUrl(path);
            HttpGet getMethod = new HttpGet(path);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            String data = response.getStatusLine().getReasonPhrase();
            throw new WebException(code, data);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject getJson(String path) {
        return RestTools.getJson(path, null);
    }

    public static JSONObject getJson(String path, JSONObject headers) {
        try {
            CloseableHttpClient httpClient;
            HttpResponse response;
            int code;
            if (!path.startsWith("http")) {
                path = UrlTools.getUrl(path);
            }
            HttpGet getMethod = new HttpGet(path);
            getMethod.setHeader("Content-Type", "application/json");
            if (headers != null) {
                Iterator keys = headers.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = headers.getString(key);
                    getMethod.setHeader(key, val);
                }
            }
            if ((code = (response = (httpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)getMethod)).getStatusLine().getStatusCode()) == 200) {
                JSONObject array;
                String actual = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                if (actual.startsWith("{")) {
                    array = new JSONObject(actual);
                } else if (actual.startsWith("[")) {
                    array = new JSONArray(actual);
                } else {
                    throw new RuntimeException("\u8c03\u7528rest\u670d\u52a1\u5931\u8d25\u3002");
                }
                JSONObject result = new JSONObject();
                result.put("code", code);
                result.put("data", (Object)array);
                return result;
            }
            JSONObject result = new JSONObject();
            String data = response.getStatusLine().getReasonPhrase();
            result.put("code", code);
            result.put("data", (Object)data);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String put(String path) {
        return RestTools.put(path, null, null);
    }

    public static String put(String path, JSONObject value) {
        return RestTools.put(path, value, null);
    }

    public static String put(String path, JSONObject value, JSONObject headers) {
        if (value != null) {
            if (headers == null) {
                headers = new JSONObject();
            }
            headers.put("Content-Type", (Object)"application/json");
            return RestTools.request(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPut());
        }
        if (headers == null) {
            return RestTools.request(path, "", "", (HttpEntityEnclosingRequestBase)new HttpPut());
        }
        return RestTools.request(path, "", headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPut());
    }

    public static String delete(String path) {
        return RestTools.delete(path, null, null);
    }

    public static String delete(String path, JSONObject value) {
        return RestTools.delete(path, value, null);
    }

    public static String delete(String path, JSONObject value, JSONObject headers) {
        if (value != null) {
            if (headers == null) {
                headers = new JSONObject();
            }
            headers.put("Content-Type", (Object)"application/json");
            return RestTools.request(path, value.toString(), headers.toString(), new HttpDeleteWithBody());
        }
        if (headers == null) {
            return RestTools.request(path, "", "", new HttpDeleteWithBody());
        }
        return RestTools.request(path, "", headers.toString(), new HttpDeleteWithBody());
    }

    public static Object action(JSONObject param) {
        String actual;
        String url = param.getString("url");
        String data = param.getString("data");
        Integer id = (Integer)ThreadResource.SessionId.get();
        if (id != null) {
            int toId = SessionPool.getInstance().createCallSession(id.intValue(), url);
            JSONObject headers = new JSONObject();
            headers.put("session", (Object)(toId + ""));
            actual = RestTools.post(url, new JSONObject(data), headers);
        } else {
            actual = RestTools.post(url, data);
        }
        JSONObject result = new JSONObject();
        result.put("code", 200);
        if (actual.startsWith("{")) {
            JSONObject actualJson = new JSONObject(actual);
            if (actualJson.has("status")) {
                result.put("code", actualJson.get("status"));
                result.put("data", (Object)actualJson.getString("data"));
            } else {
                result.put("data", (Object)actualJson);
            }
        } else if (actual.startsWith("[")) {
            result.put("data", (Object)new JSONArray(actual));
        } else {
            result.put("data", (Object)actual);
        }
        return result;
    }

    public static String formatURL(String url, JSONObject params) {
        int capacity = params.length() * 30;
        StringBuilder buffer = new StringBuilder(capacity);
        buffer.append(url).append("?");
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = params.getString(key);
            if (!"".equals(val)) {
                buffer.append(key).append("=").append(val);
            } else {
                buffer.append(key);
            }
            if (!keys.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public static String getStandardURL(String protocolType, String url, String port, String paramStr) {
        if (port == null) {
            port = "80";
        }
        url = protocolType + "://" + url + ":" + port;
        if (paramStr != null) {
            url = url + paramStr;
        }
        return url;
    }
}

