/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class LogParser {
    public static List<File> SelectLogName(String logpath, String keyfile) throws UnsupportedEncodingException {
        Date d = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sf.format(d);
        List<File> logFile = LogParser.getFileList(logpath, date, keyfile);
        return logFile;
    }

    public static boolean contains(String source, String keys, boolean flag) throws UnsupportedEncodingException {
        String[] s = keys.split(",");
        if (!flag) {
            return source.contains(s[0]) && source.contains(s[1]);
        }
        String date = source.substring(0, 19);
        int startresult = date.compareTo(s[0]);
        int endresult = date.compareTo(s[1]);
        if (startresult > -1 && endresult < 1) {
            if (s.length > 2) {
                int i = 2;
                if (i < s.length) {
                    return source.contains(s[i]);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static JSONArray ProcessOneFile(String logpath, String keyfile, String startDate, String endDate, String keys) throws IOException {
        List<File> logFile = LogParser.SelectLogName(logpath, keyfile);
        keys = keys.trim();
        startDate = startDate.trim();
        endDate = endDate.trim();
        keys = startDate + "," + endDate + "," + keys;
        JSONArray ja = new JSONArray();
        boolean flag = true;
        for (File f : logFile) {
            StringBuilder result = new StringBuilder();
            BufferedReader bReader = new BufferedReader(new FileReader(f));
            String str = bReader.readLine();
            while (str != null) {
                if (str.equals("")) {
                    str = bReader.readLine();
                    continue;
                }
                if (LogParser.contains(str, keys, flag)) {
                    result.append(str).append("\n");
                }
                str = bReader.readLine();
            }
            bReader.close();
            if (result.equals("")) continue;
            JSONObject item = new JSONObject();
            item.put("filename", (Object)f.getName());
            item.put("logstr", (Object)result.toString());
            ja.put((Object)item);
        }
        return ja;
    }

    public static JSONArray PidSort(String logpath, String keyfile, String startDate, String endDate, String keys) throws IOException {
        List<File> logFile = LogParser.SelectLogName(logpath, keyfile);
        String key = keys.trim();
        startDate = startDate.trim();
        endDate = endDate.trim();
        keys = startDate + "," + endDate;
        JSONArray ja = new JSONArray();
        boolean flag = true;
        for (File f : logFile) {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), "GBK");
            BufferedReader bReader = new BufferedReader(isr, 0x500000);
            String str = bReader.readLine();
            while (str != null) {
                if (LogParser.contains(str = new String(str.getBytes("UTF-8"), "UTF-8"), keys, flag)) {
                    StringBuilder result = new StringBuilder();
                    String[] s = str.split("-", 5);
                    String pid = s[3].trim();
                    int t = 0;
                    for (int i = 0; i < ja.length(); ++i) {
                        JSONObject jo = (JSONObject)ja.get(i);
                        if (jo.get("filename").equals(f.getName()) && jo.get("pid").equals(pid)) {
                            String logstr = (String)jo.get("logstr");
                            logstr = logstr + result.append(str).append("\n").toString();
                            jo.put("logstr", (Object)logstr);
                            ja.put(i, (Object)jo);
                            continue;
                        }
                        ++t;
                    }
                    if (t == ja.length()) {
                        JSONObject item = new JSONObject();
                        item.put("filename", (Object)f.getName());
                        item.put("pid", (Object)pid);
                        item.put("logstr", (Object)result.append(str).append("\n").toString());
                        ja.put((Object)item);
                    }
                }
                str = bReader.readLine();
            }
            bReader.close();
        }
        return LogParser.getPidKey(ja, key);
    }

    public static JSONArray getPidKey(JSONArray ja, String key) throws UnsupportedEncodingException {
        JSONArray result = new JSONArray();
        ArrayList<String> strarray = new ArrayList<String>();
        JSONArray keyresult = new JSONArray();
        block0: for (int i = 0; i < ja.length(); ++i) {
            Object jo = new JSONObject();
            jo = (JSONObject)ja.get(i);
            String str = (String)jo.get("logstr");
            int index = str.indexOf("\u63a5\u6536\u53d1\u9001\u7684\u6d88\u606f");
            if (index == -1) continue;
            int startindex = str.substring(0, index).lastIndexOf("\n");
            startindex = startindex == -1 ? 0 : ++startindex;
            int lastindex = str.lastIndexOf("\u53d1\u9001\u7684\u6d88\u606f\u5185\u5bb9");
            if (lastindex == -1) continue;
            int endindex = str.indexOf("\n", lastindex);
            if (endindex == -1) {
                endindex = 0;
                continue;
            }
            str = str.substring(startindex, endindex + 1);
            int l = 0;
            boolean si = false;
            while (true) {
                int index1 = str.indexOf("\u63a5\u6536\u53d1\u9001\u7684\u6d88\u606f", l);
                int index2 = str.indexOf("\u63a5\u6536\u53d1\u9001\u7684\u6d88\u606f", index1 + 2);
                if (index1 == -1) continue block0;
                if (index2 == -1) {
                    int index3 = str.indexOf("\u53d1\u9001\u7684\u6d88\u606f\u5185\u5bb9", index1);
                    l = str.length();
                    if (index3 == -1) continue;
                    index2 = str.indexOf("\n", index3) + 1;
                }
                l = index2;
                if (str.substring(index1, index2).indexOf("\u53d1\u9001\u7684\u6d88\u606f\u5185\u5bb9") == -1) continue;
                index1 = (index1 = str.substring(0, index1).lastIndexOf("\n")) == -1 ? 0 : ++index1;
                int ls = str.substring(index1, index2).indexOf("\u53d1\u9001\u7684\u6d88\u606f\u5185\u5bb9") + index1;
                index2 = str.substring(ls, index2).indexOf("\n") + ls;
                index2 = index2 == -1 ? 0 : ++index2;
                strarray.add(str.substring(index1, index2));
            }
        }
        int p = 0;
        for (String s : strarray) {
            String[] st = s.split("-", 5);
            String pid = st[3].trim();
            JSONObject strobject = new JSONObject();
            strobject.put("pid", (Object)pid);
            strobject.put("logstr", (Object)s);
            strobject.put("id", p);
            result.put((Object)strobject);
            ++p;
        }
        if (key.isEmpty()) {
            keyresult = result;
        } else {
            JSONObject jos = new JSONObject();
            for (int t = 0; t < result.length(); ++t) {
                jos = (JSONObject)result.get(t);
                if (!jos.get("logstr").toString().contains(key)) continue;
                keyresult.put((Object)jos);
            }
        }
        JSONArray rs = new JSONArray();
        String pid = new String();
        JSONArray ls = new JSONArray();
        for (int i = 0; i < keyresult.length(); ++i) {
            JSONObject jos = new JSONObject();
            jos = (JSONObject)keyresult.get(i);
            pid = (String)jos.get("pid");
            ls.put(jos.get("logstr"));
            if (i + 1 < keyresult.length()) {
                JSONObject jos1 = new JSONObject();
                jos1 = (JSONObject)keyresult.get(i + 1);
                if (!pid.equals(jos1.get("pid"))) {
                    JSONObject js = new JSONObject();
                    js.put("pid", (Object)pid);
                    js.put("logstr", (Object)ls);
                    rs.put((Object)js);
                    ls = new JSONArray();
                    pid = (String)jos1.get("pid");
                }
            }
            if (i != keyresult.length() - 1) continue;
            JSONObject js = new JSONObject();
            js.put("pid", (Object)pid);
            js.put("logstr", (Object)ls);
            rs.put((Object)js);
        }
        return LogParser.delRepeatIndexid(rs);
    }

    public static List<File> getFileList(String strPath, String date, String keyfile) throws UnsupportedEncodingException {
        File dir = new File(strPath);
        File[] files = dir.listFiles();
        ArrayList<File> filelist = new ArrayList<File>();
        boolean flag = false;
        if (files != null) {
            for (File file : files) {
                String keys;
                String fileName = file.getName();
                if (file.isDirectory()) {
                    LogParser.getFileList(file.getAbsolutePath(), date, keyfile);
                }
                if (!LogParser.contains(fileName, keys = date + "," + keyfile, flag)) continue;
                String strFileName = file.getAbsolutePath();
                filelist.add(file);
            }
        }
        return filelist;
    }

    public static JSONArray delRepeatIndexid(JSONArray array) {
        JSONArray arrayTemp = new JSONArray();
        int num = 0;
        for (int i = 0; i < array.length(); ++i) {
            if (num == 0) {
                arrayTemp.put(array.get(i));
            } else {
                int numJ = 0;
                for (int j = 0; j < arrayTemp.length(); ++j) {
                    JSONObject newJsonObjectI = (JSONObject)array.get(i);
                    JSONObject newJsonObjectJ = (JSONObject)arrayTemp.get(j);
                    String index_idI = newJsonObjectI.get("pid").toString();
                    JSONArray valueI = (JSONArray)newJsonObjectI.get("logstr");
                    String index_idJ = newJsonObjectJ.get("pid").toString();
                    JSONArray valueJ = (JSONArray)newJsonObjectJ.get("logstr");
                    if (index_idI.equals(index_idJ)) {
                        valueI = LogParser.mergeJson(valueI, valueJ);
                        arrayTemp.remove(j);
                        JSONObject newObject = new JSONObject();
                        newObject.put("pid", (Object)index_idI);
                        newObject.put("logstr", (Object)valueI);
                        arrayTemp.put((Object)newObject);
                        break;
                    }
                    ++numJ;
                }
                if (numJ - 1 == arrayTemp.length() - 1) {
                    arrayTemp.put(array.get(i));
                }
            }
            ++num;
        }
        return arrayTemp;
    }

    public static JSONArray mergeJson(JSONArray array, JSONArray array1) {
        for (int i = 0; i < array1.length(); ++i) {
            array.put(array1.get(i));
        }
        return array;
    }
}

