/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;

public class DateTools {
    public static Date getNow() {
        return new Date();
    }

    public static String getNow2() {
        return DateTools.getNow("yyyy-MM-dd HH:mm:ss");
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String getNow(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }

    public static String getNowYear() {
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        return String.valueOf(year);
    }

    public static String getNowMonth() {
        Calendar now = Calendar.getInstance();
        int month = now.get(2);
        return String.valueOf(month + 1);
    }

    public static int getNowMonthAsInt() {
        return Integer.valueOf(DateTools.getNowMonth());
    }

    public static String getNowDay() {
        Calendar now = Calendar.getInstance();
        int day = now.get(5);
        return String.valueOf(day);
    }

    public static String getNowDayOfWeek() {
        Calendar now = Calendar.getInstance();
        int dayOfWeek = now.get(7);
        return String.valueOf(dayOfWeek - 1);
    }

    public static int getMonth(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date getDate = format.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(getDate);
        return cal.get(2) + 1;
    }

    public static String getYearMonth(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date getDate = format.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(getDate);
        String year = String.valueOf(cal.get(1));
        String month = String.valueOf(cal.get(2) + 1);
        format = new SimpleDateFormat("yyyyMM");
        getDate = format.parse(year + month);
        return format.format(getDate);
    }

    public static String formatConvert(String date) throws ParseException {
        return DateTools.formatDateTime(date, "yyyy-MM-dd");
    }

    public static String formatDateTime(String datetime) throws ParseException {
        return DateTools.formatDateTime(datetime, "yyyyMMddHHmmss");
    }

    public static String formatDateTime(String dateStr, String format) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = simpleDateFormat.parse(dateStr);
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static String formatDateTime(String dateStr, String format, String newFormat) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = simpleDateFormat.parse(dateStr);
        simpleDateFormat = new SimpleDateFormat(newFormat);
        return simpleDateFormat.format(date);
    }

    public static boolean compareDate(String dateStr1, String dateStr2) throws ParseException {
        return DateTools.compareFormatDate(dateStr1, dateStr2, "yyyy-MM-dd HH:mm:ss");
    }

    public static boolean compareFormatDate(String dateStr1, String dateStr2, String formatStr) throws ParseException {
        Date date2;
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        Date date1 = format.parse(dateStr1);
        if (date1.before(date2 = format.parse(dateStr2))) {
            return false;
        }
        if (date1.after(date2)) {
            return true;
        }
        return true;
    }

    public static String nextMonth(String date, String day) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date target = simpleDateFormat.parse(date);
        Calendar now = Calendar.getInstance();
        now.setTime(target);
        now.set(now.get(1), now.get(2) + 1, Integer.parseInt(day), 0, 0, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(now.getTime());
    }

    public static String getCurrentMonthStart() {
        return DateTools.getStartDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), "month", "yyyy-MM-dd");
    }

    public static String getLastMonthStart() {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        return DateTools.getStartDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime()), "month", "yyyy-MM-dd");
    }

    public static String getFrontLastMonthStart() {
        Calendar c = Calendar.getInstance();
        c.add(2, -2);
        return DateTools.getStartDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime()), "month", "yyyy-MM-dd");
    }

    public static String getStartDate(String date, String type) {
        return DateTools.getStartDate(date, type, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getStartDate(String date, String type, String format) {
        if (DateTools.isNull(date) || DateTools.isNull(type)) {
            throw new RuntimeException("\u83b7\u53d6\u5f00\u59cb\u65f6\u95f4: \u60a8\u6240\u4f20\u7684\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01\uff01");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime getDate = LocalDateTime.parse(date, formatter);
        LocalDate firstDate = "month".equals(type.toLowerCase()) ? getDate.toLocalDate().with(TemporalAdjusters.firstDayOfMonth()) : ("year".equals(type.toLowerCase()) ? getDate.toLocalDate().with(TemporalAdjusters.firstDayOfYear()) : getDate.toLocalDate());
        LocalDateTime result = LocalDateTime.of(firstDate, LocalTime.of(0, 0, 0));
        return DateTimeFormatter.ofPattern(format).format(result);
    }

    public static String getNextMonthEnd() {
        Calendar c = Calendar.getInstance();
        c.add(2, 1);
        return DateTools.getEndDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime()), "month", "yyyy-MM-dd");
    }

    public static String getEndDate(String date, String type) {
        return DateTools.getEndDate(date, type, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getEndDate(String date, String type, String format) {
        if (DateTools.isNull(date) || DateTools.isNull(type)) {
            throw new RuntimeException("\u83b7\u53d6\u6700\u540e\u65f6\u95f4: \u60a8\u6240\u4f20\u7684\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01\uff01");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime getDate = LocalDateTime.parse(date, formatter);
        LocalDate firstDate = "month".equals(type.toLowerCase()) ? getDate.toLocalDate().with(TemporalAdjusters.lastDayOfMonth()) : ("year".equals(type.toLowerCase()) ? getDate.toLocalDate().with(TemporalAdjusters.lastDayOfYear()) : getDate.toLocalDate());
        LocalDateTime result = LocalDateTime.of(firstDate, LocalTime.of(23, 59, 59));
        return DateTimeFormatter.ofPattern(format).format(result);
    }

    public static String getStairStartDate(String start, Object cycle, String handdate) throws Exception {
        if ("".equals(start) || start == null) {
            throw new Exception("\u60a8\u6240\u4f20\u7684\u9636\u68af\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        if (cycle == null) {
            throw new Exception("\u60a8\u6240\u4f20\u7684\u9636\u68af\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        if ("".equals(handdate) || handdate == null) {
            throw new Exception("\u60a8\u6240\u4f20\u7684\u6284\u8868\u5355\u4e0b\u53d1\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar now = Calendar.getInstance();
        String[] str = start.split("-");
        int beginMonth = Integer.parseInt(str[0]);
        int nowMonth = DateTools.getMonth(handdate);
        if (DateTools.isLastYear(handdate)) {
            now.set(1, now.get(1) - 1);
        } else {
            now.set(1, now.get(1));
        }
        now.set(2, beginMonth - 1);
        now.set(5, Integer.parseInt(str[1]));
        now.add(2, new BigDecimal(nowMonth - beginMonth).divide(new BigDecimal(cycle.toString()), 2, 5).setScale(0, 3).multiply(new BigDecimal(cycle.toString())).intValue());
        return format.format(now.getTime());
    }

    private static boolean isLastYear(String date) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date getDate = format.parse(date);
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        cal.setTime(getDate);
        int year = cal.get(1);
        return year < currentYear;
    }

    private static boolean isNull(String param) {
        return "".equals(param) || param == null;
    }

    public static String dateDisp(Date before, Date after) {
        long time = after.getTime() - before.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(after) + "-" + dateFormat.format(before) + " \u65f6\u95f4\u5dee:" + time;
    }

    public static String getDiffDate(String type, String number, String format) {
        Calendar calendar = Calendar.getInstance();
        switch (type.toUpperCase()) {
            case "YEAR": {
                calendar.add(1, Integer.parseInt(number));
                break;
            }
            case "MONTH": {
                calendar.add(2, Integer.parseInt(number));
                break;
            }
            default: {
                calendar.add(5, Integer.parseInt(number));
            }
        }
        Date date = calendar.getTime();
        format = format == null ? "yyyy-MM-dd" : format;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String getDelayDate(String date, String type, String param) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date target = format.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(target);
        switch (type.toUpperCase()) {
            case "YEAR": {
                cal.add(1, Integer.parseInt(param));
                break;
            }
            case "MONTH": {
                cal.add(2, Integer.parseInt(param));
                break;
            }
            case "DAY": {
                cal.add(5, Integer.parseInt(param));
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b\uff01\u53ef\u9009\u503c(YEAR,MONTH,DATE)");
            }
        }
        return format.format(cal.getTime());
    }
}

