/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class ConvertTools {
    public static int stringToInt(String str) {
        return Integer.parseInt(str);
    }

    public static double stringToDouble(String str) {
        return Double.parseDouble(str);
    }

    public static BigDecimal stringToBigDecimal(String num) {
        return new BigDecimal(num);
    }

    public static String bigDecimalToString(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static String byteArrayToString(byte[] bytes) throws UnsupportedEncodingException {
        return ConvertTools.byteArrayToCharsetString(bytes, "UTF-8");
    }

    public static String byteArrayToCharsetString(byte[] bytes, String charset) throws UnsupportedEncodingException {
        return new String(bytes, charset);
    }

    public static String base64Encode(byte[] bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        return new String(encoder.encode(bytes), StandardCharsets.UTF_8);
    }

    public static byte[] base64Decode(byte[] bytes) {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(bytes);
    }

    public static String byteToHexStr(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    public static byte[] hexStrToByte(String hexStr) throws DecoderException {
        return Hex.decodeHex((char[])hexStr.toCharArray());
    }

    public static byte[] StrToBytes(String str) {
        return str.getBytes();
    }

    public static String bytesToStr(byte[] bytes) {
        return new String(bytes);
    }

    public static String stringToCharset(String str, Charset oldCharset, Charset newCharset) {
        if (null != str) {
            try {
                str = new String(str.getBytes(oldCharset), newCharset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public static String hexStrToBinaryStr(String hexString) {
        StringBuilder bString = new StringBuilder();
        for (int i = 0; i < hexString.length(); ++i) {
            String tmp = "0000" + Integer.toBinaryString(Integer.parseInt(hexString.substring(i, i + 1), 16));
            bString.append(tmp.substring(tmp.length() - 4));
        }
        return bString.toString();
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(ConvertTools.binaryStrToBinaryArray(ConvertTools.hexStrToBinaryStr("4"), 8)));
    }

    public static String binaryStrToHexStr(String bString) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < bString.length(); i += 4) {
            int iTmp = 0;
            for (int j = 0; j < 4; ++j) {
                iTmp += Integer.parseInt(bString.substring(i + j, i + j + 1)) << 4 - j - 1;
            }
            tmp.append(Integer.toHexString(iTmp));
        }
        return tmp.toString();
    }

    public static byte[] binaryStrToBinaryArray(String binaryString) {
        return ConvertTools.binaryStrToBinaryArray(binaryString, 0);
    }

    public static byte[] binaryStrToBinaryArray(String binaryString, Integer length) {
        if (length == 0) {
            length = binaryString.length();
        }
        byte[] binaryArray = new byte[length.intValue()];
        char[] binaryChars = binaryString.toCharArray();
        for (int i = 0; i < binaryChars.length; ++i) {
            binaryArray[i] = binaryChars[i] == '1' ? (byte)1 : 0;
        }
        return binaryArray;
    }

    public static int ceil(Object numObj) {
        double num = Double.parseDouble(numObj.toString());
        return (int)Math.ceil(num);
    }

    public static int floor(Object numObj) {
        double num = Double.parseDouble(numObj.toString());
        return (int)Math.floor(num);
    }

    public static int round(Object numObj) {
        BigDecimal b = new BigDecimal(numObj.toString());
        return b.setScale(0, 4).intValue();
    }

    public static String replaceAll(String str) {
        return str.replace(" ", "");
    }

    public static String stringToAscii(String value, String split) {
        if (value == null) {
            return null;
        }
        StringBuilder sbu = new StringBuilder();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            sbu.append((int)chars[i]).append(split);
        }
        sbu.append((int)chars[chars.length - 1]);
        return sbu.toString();
    }

    public static String asciiToString(String value, String split) {
        String[] chars;
        if (value == null) {
            return null;
        }
        StringBuilder sbu = new StringBuilder();
        for (String aChar : chars = value.split(split)) {
            sbu.append((char)Integer.parseInt(aChar));
        }
        return sbu.toString();
    }
}

