/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileSaveTools {
    private String getNowDay() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(new Date());
    }

    private String getNowTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("_yyyy_MM_dd_hh_mm_ss");
        return formatter.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveFileReport(String rootDir, String data, String filename) {
        File dir = new File(rootDir + File.separator + this.getNowDay());
        FileOutputStream fop = null;
        File file = null;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            file = new File(dir.getAbsolutePath() + File.separator + filename + this.getNowTime());
            fop = new FileOutputStream(file);
            byte[] content = data.getBytes("utf-8");
            fop.write(content);
            fop.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fop.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file.getAbsolutePath();
    }

    public String getFileReport(String path) {
        if (path == null || "".equals(path)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public String getPathFileName(String path) {
        if (path == null || "".equals(path)) {
            return "";
        }
        path = path.replace("\\", "/");
        return path.split("/")[path.split("/").length - 1];
    }

    public String deleteFileReport(String path) {
        String result = "error";
        File file = new File(path);
        if (file.exists()) {
            file.delete();
            result = "success";
        }
        return result;
    }

    public static void main(String[] args) {
        FileSaveTools ft = new FileSaveTools();
        System.out.println(ft.getPathFileName("d:\\product\\images\\2017-09-20\\QQ\u56fe\u724720170920142810.png_2017_09_20_03_05_48"));
    }
}

