select
	*
from(
	select
			f_user_type,
			f_gasproperties,
			f_price_name,
			isnull(Convert(decimal(18,0),sum(f_gas)),0) f_gas,
			isnull(Convert(decimal(18,2),sum(f_money)),0) f_money,
			isnull(Convert(decimal(18,0),sum(f_gasall)),0) f_gasall,
			isnull(Convert(decimal(18,2),sum(f_moneyall)),0) f_moneyall
	from(
	SELECT
        case when sp.f_price_name like '%合表%' then '合表' else s.f_user_type end f_user_type,
        case when sp.f_price_name like '%商%' or sp.f_price_name like '%工业' then '商业用户'
						when sp.f_price_name like '%采暖%' then '采暖锅炉'
						when sp.f_price_name like '%合表%' then sp.f_price_type
						when sp.f_price_name like '%民用%' or sp.f_price_name like '%居民%' then '居民'
						when sp.f_price_name like '%公福%' then '公福'
						when sp.f_price_name like '%协议%' then '协议' end f_gasproperties,
			case when sp.f_price_type='阶梯气价' then c.f_price_name +'-'+f_bill_style+ '(' + CONVERT ( VARCHAR, f_price ) + ')'
						else f_bill_style+ '(' + CONVERT ( VARCHAR, f_price ) + ')'
						end f_price_name,
        f_gas,
        f_money,
				0 f_gasall,
        0 f_moneyall
    FROM
        ( SELECT
            id,
            f_user_type,
            f_gasproperties,
            f_bill_style,
						f_stairprice_id
        FROM t_sellinggas
        WHERE f_state = '有效'
            AND f_meter_type LIKE '%卡表%'
            AND f_operate_date >= '{startDate}'
            AND f_operate_date <= '{endDate}'
            AND {f_orgid}
        ) s
				left join (select * from t_stairprice where f_state='有效') sp on sp.id=s.f_stairprice_id
        LEFT JOIN (
					SELECT
							f_price_name ,
							f_price,
							f_charge_id,
							f_gas,
							f_money
					FROM
							t_chargeprice
					WHERE
							f_state = '有效'
        ) c ON c.f_charge_id= s.id
		union all

	SELECT
        case when sp.f_price_name like '%合表%' then '合表' else s.f_user_type end f_user_type,
        case when sp.f_price_name like '%商%' or sp.f_price_name like '%工业' then '商业用户'
						when sp.f_price_name like '%合表%' then sp.f_price_type
						when sp.f_price_name like '%采暖%' then '采暖锅炉'
						when sp.f_price_name like '%民用%' or sp.f_price_name like '%居民%' then '居民'
						when sp.f_price_name like '%公福%' then '公福'
						when sp.f_price_name like '%协议%' then '协议' end f_gasproperties,
				case when sp.f_price_type='阶梯气价' then c.f_price_name +'-'+f_bill_style+ '(' + CONVERT ( VARCHAR, f_price ) + ')'
						else f_bill_style+ '(' + CONVERT ( VARCHAR, f_price ) + ')'
						end f_price_name,
        0 f_gas,
        0 f_money,
				f_gas f_gasall,
        f_money f_moneyall
    FROM
        ( SELECT
            id,
            f_user_type,
            f_gasproperties,
            f_bill_style,
						f_stairprice_id
        FROM t_sellinggas
        WHERE f_state = '有效'
            AND f_meter_type LIKE '%卡表%'
            AND DATEPART(YY, f_operate_date) = DATEPART(YY, '{endDate}')
            AND {f_orgid}
        ) s
				left join (select * from t_stairprice where f_state='有效') sp on sp.id=s.f_stairprice_id
        LEFT JOIN (
					SELECT
							f_price_name ,
							f_price,
							f_charge_id,
							f_gas,
							f_money
					FROM
							t_chargeprice
					WHERE
							f_state = '有效'
        ) c ON c.f_charge_id= s.id
	) t
group by f_user_type,f_gasproperties,f_price_name
) s
where f_price_name is not null