SELECT
	isnull( SUM ( cn ), 0 ) cn,
	isnull( SUM ( sy ), 0 ) sy,
	isnull( SUM ( gf ), 0 ) gf,
	isnull( SUM ( xy ), 0 ) xy,
	isnull( SUM ( price1 ), 0 ) price1,
	isnull( SUM ( price2 ), 0 ) price2,
	isnull( SUM ( price3 ), 0 ) price3,
	isnull( SUM ( wym ), 0 ) wym,

	isnull( SUM ( sybq ), 0 ) sybq,
	isnull( SUM ( mybq ), 0 ) mybq,
	isnull( SUM ( gfbq ), 0 ) gfbq,
	isnull( SUM ( cnbq ), 0 ) cnbq,
	isnull( SUM ( hbbq ), 0 ) hbbq,

	isnull( SUM ( wcn ), 0 ) wcn,
	isnull( SUM ( wsy ), 0 ) wsy,
	isnull( SUM ( wgf ), 0 ) wgf,
	isnull( SUM ( wxy ), 0 ) wxy,
	isnull( SUM ( wcmnum ), 0 ) wcmnum,
	isnull( SUM ( wcsnum ), 0 ) wcsnum,
	isnull( SUM ( wcgnum ), 0 ) wcgnum,
	isnull( SUM ( wccnum ), 0 ) wccnum,
	isnull( SUM ( wchnum ), 0 ) wchnum,
	sum(cn+sy+gf+xy+price1+price2+price3+sybq+mybq+gfbq+cnbq+hbbq) psnum,
	sum(wym+wcn+wsy+wgf+wxy+wchnum+wcmnum+wcsnum+wcgnum+wccnum) wsnum
FROM
	(-- //查询机表卡表的交费笔数（不包含超用）
	SELECT
		CASE WHEN  f_price_name like '%采暖锅炉%' THEN 1 ELSE 0 END cn,
		0 wcn,
		CASE WHEN f_price_name LIKE '%商%' THEN 1 ELSE 0 END sy,
	    0 wsy,
		CASE WHEN  f_price_name LIKE '%公福%' THEN 1 ELSE 0 END gf,
		0 wgf,
		CASE WHEN  f_price_name LIKE '%协议%' THEN 1 ELSE 0 END xy,
		0 wxy,
		CASE WHEN (f_price_name like '%居民%' or f_price_name like '%民用%') AND ch.f_stair1amount<> 0 THEN 1 ELSE 0 END price1,
		CASE WHEN (f_price_name like '%居民%' or f_price_name like '%民用%') AND ch.f_stair2amount<> 0 AND ch.f_stair1amount= 0 THEN 1 ELSE 0 END price2,
		CASE WHEN  (f_price_name like '%居民%' or f_price_name like '%民用%') AND ch.f_stair3amount<> 0 AND ch.f_stair1amount= 0 AND ch.f_stair2amount= 0 THEN 1 ELSE 0 END price3,
		0 wym,
		0 sybq,
		0 mybq,
		0 gfbq,
		0 cnbq,
		0 hbbq,
		0 wcmnum,
		0 wcsnum,
		0 wcgnum,
		0 wccnum,
		0 wchnum
	FROM
	t_sellinggas ts
	left join (select * from t_stairprice where f_state='有效') sp on ts.f_stairprice_id=sp.id
	LEFT JOIN (
	SELECT
		f_charge_id,
        SUM ( CASE WHEN f_price_name = '阶梯1' THEN f_gas ELSE 0 END ) f_stair1amount,
        SUM ( CASE WHEN f_price_name = '阶梯2' THEN f_gas ELSE 0 END ) f_stair2amount,
        SUM ( CASE WHEN f_price_name = '阶梯3' THEN f_gas ELSE 0 END ) f_stair3amount
    FROM
        t_chargeprice
    WHERE
        f_state = '有效'
    GROUP BY
        f_charge_id
        ) ch ON ts.id = ch.f_charge_id
WHERE
	ts.f_state = '有效'
	AND ts.f_type <> '超用收费' AND f_meter_brand not like '%物联%' AND f_meter_brand not like '%远传%'
		AND ts.f_operate_date>='{startDate}'
		AND ts.f_operate_date<='{endDate}'
		AND {f_orgid}
UNION ALL
		--//查询物联远传的交费笔数（不包含超用）
		SELECT
			0 cn,
			CASE WHEN  f_price_name like '%采暖锅炉%' THEN 1 ELSE 0 END wcn,
			0 sy,
			CASE WHEN  f_price_name LIKE '%商%' THEN 1 ELSE 0 END wsy,
			0 gf,
			CASE WHEN  f_price_name LIKE '%公福%' THEN 1 ELSE 0 END wgf,
			0 xy,
			CASE WHEN  f_price_name LIKE '%协议%' THEN 1 ELSE 0 END wxy,
			0 price1,
			0 price2,
			0 price3,
			CASE WHEN  (f_price_name like '%居民%' or f_price_name like '%民用%') THEN 1 ELSE 0 END wym,
			0 sybq,
			0 mybq,
			0 gfbq,
			0 cnbq,
			0 hbbq,
			0 wcmnum,
			0 wcsnum,
			0 wcgnum,
			0 wccnum,
			0 wchnum
		FROM
		t_sellinggas ts
		left join (select * from t_stairprice where f_state='有效') sp on ts.f_stairprice_id=sp.id
		LEFT JOIN (
		SELECT
			f_charge_id,
			SUM ( CASE WHEN f_price_name = '阶梯1' THEN f_gas ELSE 0 END ) f_stair1amount,
			SUM ( CASE WHEN f_price_name = '阶梯2' THEN f_gas ELSE 0 END ) f_stair2amount,
			SUM ( CASE WHEN f_price_name = '阶梯3' THEN f_gas ELSE 0 END ) f_stair3amount
		FROM
			t_chargeprice
		WHERE
			f_state = '有效'
		GROUP BY
			f_charge_id
			) ch ON ts.id = ch.f_charge_id
	WHERE
		ts.f_state = '有效'
		AND ts.f_type <> '超用收费' AND (f_meter_brand like '%物联%' or f_meter_brand like '%远传%')
		AND ts.f_operate_date>='{startDate}'
		AND ts.f_operate_date<='{endDate}'
		AND {f_orgid}
UNION ALL
--//查询机表卡表的超用交费笔数
SELECT
	0 cn,
	0 wcn,
	0 sy,
	0 wsy,
	0 gf,
	0 wgf,
	0 xy,
	0 wxy,
	0 price1,
	0 price2,
	0 price3,
	0 wym,
    CASE WHEN f_price_name LIKE '%商%' THEN 1 ELSE 0 END sybq,
    CASE WHEN f_price_name like '%居民%' or f_price_name like '%民用%' THEN 1 ELSE 0 END mybq,
    CASE WHEN f_price_name LIKE '%公福%' THEN 1 ELSE 0 END gfbq,
    CASE WHEN f_price_name like '%采暖锅炉%' THEN 1 ELSE 0 END cnbq,
    CASE WHEN f_price_name like '%合表%' THEN 1 ELSE 0 END hbbq,
    0 wcmnum,
	0 wcsnum,
	0 wcgnum,
	0 wccnum,
	0 wchnum
FROM
	t_sellinggas ts,
	t_stairprice sp
WHERE
	ts.f_state = '有效'
	and ts.f_stairprice_id=sp.id
	and sp.f_state='有效'
	AND ts.f_type = '超用收费'
	AND f_meter_brand not like '%物联%' and f_meter_brand not like '%远传%'
		AND ts.f_operate_date>='{startDate}'
		AND ts.f_operate_date<='{endDate}'
		AND {f_orgid}
UNION ALL
--//查询物联远传的超用交费笔数
SELECT
	0 cn,
	0 wcn,
	0 sy,
	0 wsy,
	0 gf,
	0 wgf,
	0 xy,
	0 wxy,
	0 price1,
	0 price2,
	0 price3,
	0 wym,
	0 sybq,
	0 mybq,
	0 gfbq,
	0 cnbq,
	0 hbbq,
	CASE WHEN (f_price_name like '%居民%' or f_price_name like '%民用%') THEN 1 ELSE 0 END wcmnum,
	CASE WHEN f_price_name like  '%商%' THEN 1 ELSE 0 END wcsnum,
	CASE WHEN f_price_name like  '%公福%' THEN 1 ELSE 0 END wcgnum,
	CASE WHEN f_price_name like  '%采暖锅炉%' THEN 1 ELSE 0 END wccnum,
	CASE WHEN f_price_name like '%合表%' THEN 1 ELSE 0 END wchnum
FROM
	t_sellinggas ts,
	t_stairprice sp
WHERE
	ts.f_state = '有效'
	and ts.f_stairprice_id=sp.id
	and sp.f_state='有效'
	AND ts.f_type = '超用收费'
	AND (f_meter_brand like '%物联%' or f_meter_brand like '%远传%')
		AND ts.f_operate_date>='{startDate}'
		AND ts.f_operate_date<='{endDate}'
		AND {f_orgid}
	) a