select
	 f_price_name,
	 count(distinct f_userinfo_id) user_number,
	 sum(f_gas) f_gas,
	 sum(f_money) f_money
from(
	select
				case when s.f_price_type='固定气价' then s.f_price_name
					 when ch.f_price_name='阶梯1' then s.f_price_name+'1档'
					 when ch.f_price_name='阶梯2' then s.f_price_name+'2档'
					 when ch.f_price_name='阶梯3' then s.f_price_name+'3档'
					 else  s.f_price_name+'1档' end f_price_name,
			   sp.f_userinfo_id,
			   case when ch.f_gas is null then sp.f_pregas else isnull(ch.f_gas,0) end f_gas,
			   case when ch.f_money is null then sp.f_preamount else isnull(ch.f_money,0) end f_money
	from t_sellinggas sp
	left join t_stairprice s on cast(sp.f_stairprice_id as varchar) = cast(s.id as varchar)
	left join (select * from t_chargeprice where f_money>0 and f_state='有效') ch on s.id = ch.f_charge_id
	where sp.f_operate_date>='{startDate}' and sp.f_operate_date<='{endDate}'
		and sp.f_state='有效'
) s group by f_price_name