	select
	 f_price_name,
	 count(distinct f_userinfo_id) user_number,
	 sum(f_gas) f_gas,
	 sum(f_money) f_money
	from (
		select
			case when s.f_price_type='固定气价' then s.f_price_name
				 when ch.f_price_name='阶梯1' then s.f_price_name+'1档'
				 when ch.f_price_name='阶梯2' then s.f_price_name+'2档'
				 when ch.f_price_name='阶梯3' then s.f_price_name+'3档'
				 else  s.f_price_name+'1档' end f_price_name,
		   h.f_userinfo_id,
		   case when ch.f_gas is null then h.f_oughtamount else isnull(ch.f_gas,0) end f_gas,
		   case when ch.f_money is null then h.f_oughtfee else isnull(ch.f_money,0) end f_money
		from t_handplan h
		left join t_stairprice s on h.f_stairprice_id = s.id
		left join (
			select
				f_hand_id,
				sum(f_debt_money) f_debt_money,
				sum(f_overdue) f_overdue,
				sum(f_charge_money) f_charge_money
			from t_sellinghand where f_state='有效'
			group by f_hand_id
		) sh on h.id = sh.f_hand_id
		left join (select * from t_chargeprice where f_money>0 and f_state='有效') ch on h.id = ch.f_hand_id
		left join t_sellinggas se on h.f_sell_id = se.id
		where h.f_hand_date<'{startDate}' and f_meter_state='已抄表' and f_hand_state='有效'
			  and se.f_state='有效' and h.f_oughtamount>0
			  and (se.f_operate_date>='{startDate}' or h.f_whether_pay='否')
	) h
	group by f_price_name