select
 tss.f_meter_type,
 tss.f_gasproperties,
 SUM ( case when tss.f_payment like '%现金%' then tss.f_collection else 0 end) f_xianjin,
 SUM ( case when tss.f_payment = '转账' then tss.f_collection else 0 end) f_zhuanzhang,
 SUM ( case when tss.f_payment = '刷卡' then tss.f_collection else 0 end) f_shuka,
 SUM ( case when tss.f_payment = '微信支付' then tss.f_collection else 0 end) f_weixin,
 SUM ( case when tss.f_payment like '_扫码盒%' then tss.f_collection else 0 end) f_saomahe,
 SUM ( case when tss.f_payment = '无线扫码盒%' then tss.f_collection else 0 end) f_wxsaomahe,
 SUM ( case when tss.f_payment = '调价退费' then tss.f_collection else 0 end) f_tiaojiatf,
 SUM ( case when tss.f_payment = '电子气费' then tss.f_collection else 0 end) f_dzqifei,
 SUM ( case when tss.f_payment = '银行代收' then tss.f_collection else 0 end) f_yhdaishou,
 SUM ( case when tss.f_payment = '免交' then tss.f_collection else 0 end) f_mianjiao
from
(
select
	case
		when od.f_typename='初装费' then '初装费'
		when od.f_typename='保证金' then '用气保证金'
		else
			'其他收费'
		end f_meter_type,
	case
		when od.f_typename='初装费' then ts.f_gasproperties
		when od.f_typename='保证金' then ts.f_gasproperties
		else
			case
			 when od.f_brand_spec='服务类' then '服务类'
			 when od.f_brand_spec='配件类' then '配件类'
			 else
				'其他'
			end
		end f_gasproperties,
	oe.f_payment,
	sum(case
		when od.f_typename='初装费' then oe.f_collection
		when od.f_typename='保证金' then oe.f_collection
		else
			case
			 when od.f_brand_spec='服务类' then oe.f_collection
			 when od.f_brand_spec='配件类' then oe.f_collection
			 else
				oe.f_collection
			end
		end) f_collection
from t_othercharge oe
left join
	t_othercharge_detail od
on od.f_othercharge_id=oe.id
left join
	t_userinfo t
on t.f_userinfo_id=oe.f_userinfo_id
left join
	t_userfiles ts
on t.f_userinfo_id=ts.f_userinfo_id
where
	ts.f_table_state='正常'
	and oe.f_operate_date>='{ startDate }'
	and oe.f_operate_date<='{ endDate }'
group by oe.f_payment,od.f_typename,ts.f_gasproperties,od.f_brand_spec
) tss
group by
	tss.f_meter_type,
	tss.f_gasproperties