SELECT f_filiale AS f_filiale,
	f_order_man AS f_order_man,
	servciesum,
	wxyiwansum,
	wxweiwansum,
	dhyiwansum,
	dhweiwansum
FROM
	(
	SELECT
		f_filiale,
		f_order_man,
		SUM ( servciesum ) AS servciesum,
		SUM ( wxyiwansum ) AS wxyiwansum,
		SUM ( wxweiwansum ) AS wxweiwansum,
		SUM ( dhyiwansum ) AS dhyiwansum,
		SUM ( dhweiwansum ) AS dhweiwansum
	FROM
		(
		SELECT
			f_filiale,
			f_order_man,
			COUNT ( * ) AS servciesum,
			0 wxyiwansum,
			0 wxweiwansum,
			0 dhyiwansum,
			0 dhweiwansum
		FROM
			( SELECT S.f_order_man, S.f_service_id, S.f_created_date, S.f_filiale FROM t_service S ) tb
		WHERE
			tb.f_order_man IS NOT NULL
			AND { condition }
		GROUP BY
			f_filiale,
			f_order_man UNION ALL
		SELECT
			f_filiale,
			f_order_man,
			0 servciesum,
			COUNT ( * ) AS wxyiwansum,
			0 wxweiwansum,
			0 dhyiwansum,
			0 dhweiwansum
		FROM
			(
			SELECT
				S.f_order_man,
				S.f_service_id,
				S.f_created_date,
				S.f_filiale,
				S.f_repairtype,
				SA.*
			FROM
				t_service S
				LEFT JOIN ( SELECT * FROM ACTIVITYINS act WHERE act.id = ( SELECT MAX ( id ) FROM ACTIVITYINS WHERE PROCESSID = act.PROCESSID ) ) SA ON s.F_PROCESSID = sa.PROCESSID
			) tb
		WHERE
			tb.defname = '维修完成'
			AND tb.f_repairtype <> '点火通气'
			AND tb.f_order_man IS NOT NULL
			AND { condition }
		GROUP BY
			f_filiale,
			f_order_man UNION ALL
		SELECT
			f_filiale,
			f_order_man,
			0 servciesum,
			0 wxyiwansum,
			COUNT ( * ) AS wxweiwansum,
			0 dhyiwansum,
			0 dhweiwansum
		FROM
			(
			SELECT
				S.f_order_man,
				S.f_service_id,
				S.f_created_date,
				S.f_filiale,
				S.f_repairtype,
				SA.*
			FROM
				t_service S
				LEFT JOIN ( SELECT * FROM ACTIVITYINS act WHERE act.id = ( SELECT MAX ( id ) FROM ACTIVITYINS WHERE PROCESSID = act.PROCESSID ) ) SA ON s.F_PROCESSID = sa.PROCESSID
			) tb
		WHERE
			tb.defname <> '维修完成'
			AND tb.f_repairtype <> '点火通气'
			AND tb.f_order_man IS NOT NULL
			AND { condition }
		GROUP BY
			f_filiale,
			f_order_man UNION ALL
		SELECT
			f_filiale,
			f_order_man,
			0 servciesum,
			0 wxyiwansum,
			0 wxweiwansum,
			COUNT ( * ) AS dhyiwansum,
			0 dhweiwansum
		FROM
			(
			SELECT
				S.f_order_man,
				S.f_service_id,
				S.f_created_date,
				S.f_filiale,
				S.f_repairtype,
				SA.*
			FROM
				t_service S
				LEFT JOIN ( SELECT * FROM ACTIVITYINS act WHERE act.id = ( SELECT MAX ( id ) FROM ACTIVITYINS WHERE PROCESSID = act.PROCESSID ) ) SA ON s.F_PROCESSID = sa.PROCESSID
			) tb
		WHERE
			tb.defname = '维修完成'
			AND tb.f_repairtype = '点火通气'
			AND tb.f_order_man IS NOT NULL
			AND { condition }
		GROUP BY
			f_filiale,
			f_order_man UNION ALL
		SELECT
			f_filiale,
			f_order_man,
			0 servciesum,
			0 wxyiwansum,
			0 wxweiwansum,
			0 dhyiwansum,
			COUNT ( * ) AS dhweiwansum
		FROM
			(
			SELECT
				S.f_order_man,
				S.f_service_id,
				S.f_created_date,
				S.f_filiale,
				S.f_repairtype,
				SA.*
			FROM
				t_service S
				LEFT JOIN ( SELECT * FROM ACTIVITYINS act WHERE act.id = ( SELECT MAX ( id ) FROM ACTIVITYINS WHERE PROCESSID = act.PROCESSID ) ) SA ON s.F_PROCESSID = sa.PROCESSID
			) tb
		WHERE
			tb.defname <> '维修完成'
			AND tb.f_repairtype = '点火通气'
			AND tb.f_order_man IS NOT NULL
			AND { condition }
		GROUP BY
			f_filiale,
			f_order_man
		) a
	GROUP BY
		f_filiale,
	f_order_man
	) b