select 1 f_sum_count, ss.*,u2.f_userinfo_code,u3.f_area,  --列表字段
  --下面是合计字段(除总合计，总合计条数及气量，直接累加金额)
  case when  ss.f_type<>'补气'  then f_pregas else 0 end  f_shouru_gas, --除补气外总气量
  case when  ss.f_type<>'补气'  then f_collection else 0 end  f_shouru_fee --除补气外总金额
 from (
	SELECT
	    s.id,
			s.f_userinfo_id,
			s.f_user_type,
			s.f_user_name,
			s.f_state,
			s.f_operate_date,
			isnull(f_stair1amount, 0) f_stair1amount,
			isnull(f_stair1price, 0) f_stair1price,
			isnull(f_stair2amount, 0) f_stair2amount,
			isnull(f_stair2price, 0) f_stair2price,
			isnull(f_stair3amount, 0) f_stair3amount,
			isnull(f_stair3price, 0) f_stair3price,
			s.f_pregas,
			s.f_preamount,
			s.f_collection,
			f_zones,
			s.f_address,
		  s.f_meter_brand,
			s.f_balance,
			s.f_curbalance,
			s.f_payment,
			s.f_operator,
			s.f_type,
			isnull(s.f_comments,'') f_comments,
			s.f_orgid,
			s.f_depid,
			s.f_operatorid,
			s.f_pay_id,
			s.f_terminal_num
	 from
	   (
			select f_userinfo_id,f_user_type,s.id,f_pregas,f_preamount,f_collection,
			f_balance,f_curbalance,f_payment,f_orgid,f_depid,f_operatorid,f_zones,f_user_name,f_type,f_operator,f_comments,
			isnull(f_write_date,f_operate_date) f_operate_date,f_state,f_address,f_meter_brand,f_pay_id,f_write_operator as f_terminal_num
			from t_sellinggas s
			where f_state<>'无效' and isnull(f_write_card,'')<>'未写卡'
			and isnull(f_write_date,f_operate_date)>='{startDate}' and isnull(f_write_date,f_operate_date)<='{endDate}'
			and {condition}  --传组织
		) s
		LEFT JOIN (
			SELECT
				f_charge_id f_charge_id,
				SUM (CASE f_price_name WHEN '阶梯1' THEN f_gas WHEN '固定气价' THEN f_gas ELSE 0 END) f_stair1amount,
				SUM (CASE f_price_name WHEN '阶梯1' THEN f_price WHEN '固定气价' THEN f_price ELSE 0 END ) f_stair1price,
				SUM (CASE f_price_name WHEN '阶梯2' THEN f_gas ELSE 0 END) f_stair2amount,
				SUM (CASE f_price_name WHEN '阶梯2' THEN f_price ELSE 0 END) f_stair2price,
				SUM (CASE f_price_name WHEN '阶梯3' THEN f_gas ELSE 0 END) f_stair3amount,
				SUM (CASE f_price_name WHEN '阶梯3' THEN f_price ELSE 0 END) f_stair3price
			FROM
				t_chargeprice
			WHERE
				f_charge_id IS NOT NULL
			GROUP BY
				f_charge_id
	) c ON s.id = c.f_charge_id
    UNION ALL
	SELECT
	  s.id,
    f_userinfo_id,
    f_user_type,
		f_user_name,
		f_state AS f_state,
		f_operate_date AS f_operate_date,
		0 AS f_stair1amount,
		0 AS f_stair1price,
		0 AS f_stair2amount,
		0 AS f_stair2price,
		0 AS f_stair3amount,
		0 AS f_stair3price,
		f_pregas AS f_pregas,
		f_preamount AS f_preamount,
		f_preamount AS f_collection,
		f_address,
		f_meter_brand,
		f_zones,
		0 f_balance,
	    0 f_curbalance,
		'' f_payment,
		s.f_operator,
		'补气' AS f_type,
		isnull(f_othereason,'') AS f_comments,
		s.f_orgid,
		s.f_depid,
		s.f_operatorid,
		null f_pay_id,
		f_write_operator as  f_terminal_num
	FROM
		t_fillgas s
		where f_state<>'无效'
	and f_operate_date>='{startDate}'  and f_operate_date<='{endDate}'
	and {condition}  --传组织
) ss
 left join t_userinfo u2 on ss.f_userinfo_id=u2.f_userinfo_id
 left join t_user_address u3 on u2.f_userinfo_id=u3.f_userinfo_id
order by {orderitem},ss.id



