SELECT
	f.f_userinfo_code,
	f.f_user_name,
	sd.f_meternumber,
	sd.f_address,
	sum (st.f_over_oughtfee) f_over_oughtfee,
	sum (st.f_balance) f_balance,
	sum (st.f_last_tablebase) f_last_tablebase,
	sum (st.f_tablebase) f_tablebase,
	sum (st.f_oughtamount) f_oughtamount,
	sum (st.f_debt_money) f_debt_money , -- 本期实收
	case when (isnull(sum(st.f_debt_money),0) = 0) then 0 else sum (st.f_debt_money)/sum(st.f_oughtamount) end recovery_rate,
	sum (st.f_collection) f_collection



FROM(
--期初预存金额
select
	u.f_userinfo_id,

	case when sh.f_balance is null then 0 else sh.f_balance end f_last_tablebase,
	0 f_tablebase,
	0 f_oughtamount,
	0 f_debt_money, -- 本期实收
	0 f_balance,
	0 f_over_oughtfee,
	0 f_collection
 from t_userinfo u left join (
	select f_userinfo_id,f_balance
	from t_sellinghand sh
	where id in (
		select max(id) from t_sellinghand where f_userinfo_id=sh.f_userinfo_id and f_operate_date<='{endDate}'and f_state='有效' group by f_userinfo_id
	) and f_balance>0
) sh on u.f_userinfo_id = sh.f_userinfo_id

union all
--期初累计欠费
select
	 f_userinfo_id,
	 0 f_balance,
	 sum(f_oughtfee) f_tablebase,
	 0 f_oughtamount,
	 0 f_debt_money, -- 本期实收
	 0 f_balance,
	 0 f_over_oughtfee,
	 0 f_collection
from(
	select
	 f_userinfo_id,sum(f_oughtfee-isnull(f_debt_money,0)) f_oughtfee
	from t_handplan h left join (
		select
			f_hand_id,sum(f_debt_money) f_debt_money
		from t_sellinghand
		where f_state='有效' and f_operate_date<'{endDate}'
		group by f_hand_id
	) sh on h.id=sh.f_hand_id
	where f_hand_date<='{endDate}'
	and f_hand_state='有效'
	and f_meter_state='已抄表' and f_whether_pay='否'
	group by f_userinfo_id
 union all
	select
	 f_userinfo_id,sum(isnull(f_debt_money,0)) f_oughtfee
	from t_handplan h left join (
		select
			f_hand_id,sum(f_debt_money) f_debt_money
		from t_sellinghand
		where f_state='有效' and f_operate_date>= '{startDate}'
		group by f_hand_id
	) sh on h.id=sh.f_hand_id
	where f_hand_date<='{endDate}'
	and f_hand_state='有效'
	and f_meter_state='已抄表' and f_whether_pay='是'
	group by f_userinfo_id
) sh group by
f_userinfo_id

union all

--本期应收
select
	f_userinfo_id,
	sum(f_oughtfee) f_oughtamount,
	0 f_last_tablebase,
	0 f_tablebase,
	0 f_debt_money, -- 本期实销
	0 f_balance,
	0 f_over_oughtfee,
	0 f_collection
from t_handplan
where f_hand_date>='{startDate}' and f_hand_date<='{endDate}'
	and f_hand_state='有效'
	and f_meter_state='已抄表'
GROUP BY
	f_userinfo_id
union all
--本期预存金额  本期实销 本期实收
select
	f_userinfo_id,
	sum(f_debt_money) f_debt_money,
-- 	sum(f_charge_money) f_charge_money,
-- 	sum(f_debt_money) f_debt_money,
	0 f_oughtamount,
	0 f_last_tablebase,
	0 f_tablebase,
	0 f_balance,
	0 f_over_oughtfee,
	0 f_collection
from(
	select
		f_userinfo_id,
		f_charge_money f_collection,
		case when f_type='预存款' then f_charge_money else 0 end f_charge_money,
		f_debt_money
	 from t_sellinghand
	where  f_operate_date>='{startDate}' and f_operate_date<='{endDate}'  and f_state='有效'
) s group by f_userinfo_id

union all
--期末预存金额
select
	u.f_userinfo_id,
	case when sh.f_balance is null then 0 else sh.f_balance end f_balance,
	0 f_last_tablebase,
	0 f_tablebase,
	0 f_oughtamount,
	0 f_debt_money, -- 本期实收
	0 f_over_oughtfee,
	0 f_collection
 from t_userinfo u left join (
	select f_userinfo_id,f_balance
	from t_sellinghand sh
	where id in (
		select max(id) from t_sellinghand where f_userinfo_id=sh.f_userinfo_id and f_operate_date<='{endDate}' and f_state='有效' group by f_userinfo_id
	) and f_balance>0
) sh on u.f_userinfo_id = sh.f_userinfo_id
union all
--期末累计欠费
select
	f_userinfo_id,
	sum(f_oughtfee) f_over_oughtfee,
	0 f_balance,
	0 f_last_tablebase,
	0 f_tablebase,
	0 f_oughtamount,
	0 f_debt_money, -- 本期实收
	0 f_collection
from(
	select
	 f_userinfo_id,sum(f_oughtfee-isnull(f_debt_money,0)) f_oughtfee
	from t_handplan h left join (
		select
			f_hand_id,sum(f_debt_money) f_debt_money
		from t_sellinghand
		where f_state='有效' and f_operate_date<='{endDate}'
		group by f_hand_id
	) sh on h.id=sh.f_hand_id
	where f_hand_date<='{endDate}'
	and f_hand_state='有效'
	and f_meter_state='已抄表' and f_whether_pay='否'
	group by f_userinfo_id
 union all
	select
	 f_userinfo_id,sum(isnull(f_debt_money,0)) f_oughtfee
	from t_handplan h left join (
		select
			f_hand_id,sum(f_debt_money) f_debt_money
		from t_sellinghand
		where f_state='有效' and f_operate_date>= '{startDate}'
		group by f_hand_id
	) sh on h.id=sh.f_hand_id
	where f_hand_date<='{endDate}'
	and f_hand_state='有效'
	and f_meter_state='已抄表' and f_whether_pay='是'
	group by f_userinfo_id
) sh group by
f_userinfo_id

union all
--本期实收
select
	f_userinfo_id,
	sum(f_collection) f_collection ,
	0 f_over_oughtfee,
	0 f_balance,
	0 f_last_tablebase,
	0 f_tablebase,
	0 f_oughtamount,
	0 f_debt_money -- 本期实收
from t_sellinggas
where f_operate_date>='{startDate}' and f_operate_date<='{endDate}'
	and f_state!='无效'
group by f_userinfo_id
) st
left join
t_userinfo f
on f.f_userinfo_id=st.f_userinfo_id
left JOIN
	(SELECT s.f_userinfo_id,s.f_meternumber,ad.f_address from t_userfiles s left join t_user_address ad on s.f_useraddress_id = ad.id where f_whether_hairpin='正常') sd
on
	st.f_userinfo_id=sd.f_userinfo_id
where
    {condition}
group by
   f.f_userinfo_code,
	f.f_user_name,
	sd.f_meternumber,
	sd.f_address
ORDER BY f_userinfo_code