SELECT
	ts.f_month,
	SUM(ts.f_last_balance) f_last_balance,
	SUM(ts.f_money_pay) f_money_pay,
	SUM(ts.f_wechat_pay) f_wechat_pay,
	SUM(ts.f_bank_pay) f_bank_pay,
	SUM(ts.f_money_pay+ts.f_wechat_pay+ts.f_bank_pay) f_sum_pay,
	SUM(ts.f_pre_deduct_money) f_pre_deduct_money,
	SUM(ts.f_balance) f_balance
from(
SELECT
	f_month,
	nd.f_last_balance,
	ISNULL( SUM ( CASE s.f_payment WHEN '现金缴费' THEN s.f_preamount ELSE 0 END ), 0 ) f_money_pay,
	ISNULL( SUM ( CASE s.f_payment WHEN '微信支付' THEN s.f_preamount ELSE 0 END ), 0 ) f_wechat_pay,
	ISNULL( SUM ( CASE s.f_payment WHEN '银行转账' THEN s.f_preamount ELSE 0 END ), 0 ) f_bank_pay,
	SUM(hd.f_debt_money) f_pre_deduct_money,
	xd.f_balance
FROM
	(	select max(id) aid , min(id) iid,f_userinfo_id,f_payment,sum(f_preamount) f_preamount,CONVERT(VARCHAR(7),f_operate_date,120) f_month
		from t_sellinggas ts
		where
			exists(select f_userinfo_id from t_sellinggas  where f_state = '有效' and f_meter_type='机表'
			 AND f_operate_date>='{ startDate }'
             AND f_operate_date<='{ endDate }' and f_userinfo_id=ts.f_userinfo_id  group by f_userinfo_id having max(id)=ts.id)
		group by f_userinfo_id,f_payment,CONVERT(VARCHAR(7),f_operate_date,120)
	) s
LEFT JOIN
(	select
		f_sell_id,
		f_balance
	from t_sellinghand h
	where f_state='有效' and exists(select f_sell_id from t_sellinghand group by f_sell_id having h.id=max(id) )
) xd ON s.aid=xd.f_sell_id
LEFT JOIN
(	select
		f_sell_id,
		f_last_balance
	from t_sellinghand h
	where f_state='有效' and exists(select f_sell_id from t_sellinghand group by f_sell_id having h.id=min(id) )

) nd ON s.iid=nd.f_sell_id
LEFT JOIN(
	select
		f_sell_id,
		sum(f_debt_money) f_debt_money
	from t_sellinghand
	where f_state='有效'
	     AND f_operate_date>='{ startDate }'
         AND f_operate_date<='{ endDate }'
	group by f_sell_id
) hd ON s.iid=hd.f_sell_id
where exists(select f_userinfo_id from t_userinfo where { condition } and f_userinfo_id=s.f_userinfo_id)
GROUP BY
	f_month,nd.f_last_balance,xd.f_balance
) ts
GROUP BY
	ts.f_month
ORDER BY ts.f_month