SELECT
	znj.f_month,
	SUM(ISNULL(znj.f_last_balance,0)) f_last_balance,
	SUM(znj.f_account) f_account,
	SUM(ISNULL(znj.f_money_pay,0)) f_money_pay,
	SUM(ISNULL(znj.f_wechat_pay,0)) f_wechat_pay,
	SUM(ISNULL(znj.f_bank_pay,0)) f_bank_pay,
	SUM(ISNULL(znj.jms,0)) f_reduction,
	SUM(znj.f_money_pay+znj.f_wechat_pay+znj.f_bank_pay+znj.jms) f_sum_pay,
	SUM(ISNULL(znj.f_balance,0)) f_balance
from
(
SELECT
	DATEPART( Mm, d.f_operator_date ) f_month,
	(SELECT f_latefee_ought from t_latefee_record td where td.f_latefee_ought >= 0 and td.id=min(d.id) ) f_last_balance,
	ISNULL( SUM ( CASE WHEN f_latefee_ought >= 0 AND n.f_whether_pay= '是' AND s.f_payment= '现金缴费' THEN f_latefee_ought END ), 0 ) f_money_pay,
	ISNULL( SUM ( CASE WHEN f_latefee_ought >= 0 AND n.f_whether_pay= '是' AND s.f_payment= '微信支付' THEN f_latefee_ought END ), 0 ) f_wechat_pay,
	ISNULL( SUM ( CASE WHEN f_latefee_ought >= 0 AND n.f_whether_pay= '是' AND s.f_payment= '银行转账' THEN f_latefee_ought END ), 0 ) f_bank_pay,
	ISNULL( SUM ( CASE WHEN f_latefee_ought < 0 THEN f_latefee_ought END ), 0 ) jms,
	SUM (f_latefee_ought) f_account,
	(SELECT f_latefee_ought from t_latefee_record td  where td.f_latefee_ought >= 0 and td.id=max(d.id) ) f_balance
FROM
   t_latefee_record d
left join
	t_handplan n
on d.f_hand_id=n.id
left join
	t_sellinggas s
on d.f_selling_id=s.id
WHERE
	d.f_operator_date>= '{startDate}'
	and d.f_operator_date<='{endDate}'
	and n.f_hand_state='有效'
	AND exists(select f_userinfo_id from t_userinfo where { condition } and f_userinfo_id=n.f_userinfo_id)
GROUP BY
	n.f_userinfo_id,
	DATEPART( Mm, d.f_operator_date )
) znj
GROUP BY
	znj.f_month

