 SELECT
	f_month,
	f_orgname,
	s.f_my_num,
	s.f_sy_num,
	s.f_gy_num,
	s.f_jt_num,
	(s.f_my_num+s.f_sy_num+s.f_gy_num+s.f_jt_num) f_sum_num,
	s.f_my_gas,
	s.f_sy_gas,
	s.f_gy_gas,
	s.f_jt_gas,
	(s.f_my_gas+s.f_sy_gas+s.f_gy_gas+s.f_jt_gas) f_sum_gas,
	s.f_my_account,
	s.f_sy_account,
	s.f_gy_account,
	s.f_jt_account,
	(s.f_my_account+s.f_sy_account+s.f_gy_account+s.f_jt_account) f_sum_account
 FROM
 (
 SELECT
	f_month,
	f_orgname,
	ISNULL(COUNT(CASE th.f_gasproperties WHEN '居民用气' THEN f_userinfo_id END), 0) f_my_num,
	ISNULL(COUNT(CASE th.f_gasproperties WHEN '商业用气' THEN f_userinfo_id END), 0) f_sy_num,
	ISNULL(COUNT(CASE th.f_gasproperties WHEN '工业用气' THEN f_userinfo_id END), 0) f_gy_num,
	ISNULL(COUNT(CASE th.f_gasproperties WHEN '集体用气' THEN f_userinfo_id END), 0) f_jt_num,

	ISNULL(SUM(CASE th.f_gasproperties WHEN '居民用气' THEN th.f_oughtamount END), 0) f_my_gas,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '商业用气' THEN th.f_oughtamount END), 0) f_sy_gas,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '工业用气' THEN th.f_oughtamount END), 0) f_gy_gas,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '集体用气' THEN th.f_oughtamount END), 0) f_jt_gas,

	ISNULL(SUM(CASE th.f_gasproperties WHEN '居民用气' THEN th.f_oughtfee END), 0) f_my_account,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '商业用气' THEN th.f_oughtfee END), 0) f_sy_account,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '工业用气' THEN th.f_oughtfee END), 0) f_gy_account,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '集体用气' THEN th.f_oughtfee END), 0) f_jt_account
 FROM
		(select
				CONVERT(VARCHAR(7),f_hand_date,120) f_month,
				f_orgname,
				f_gasproperties,
				f_userinfo_id,
				sum(f_oughtamount) f_oughtamount,
				sum(f_oughtfee) f_oughtfee
		from t_handplan
		where f_hand_state='有效'
		    AND f_meter_state = '已抄表'
		    AND {condition}
		group by CONVERT(VARCHAR(7),f_hand_date,120),f_gasproperties,f_userinfo_id,f_orgname
		)  th
 GROUP BY
	f_month,
	f_orgname
 ) s
 ORDER BY f_month
