SELECT
	row_number ( ) OVER ( ORDER BY u.f_userinfo_code ) number,
	h.id,
	a.f_residential_area, -- 小区名称
	f.f_inputtor,   --表档案抄表员
	a.f_building,   --楼号
	a.f_unit,  --单元号
	a.f_floor+ '-' + a.f_room floor_room,  --楼层加门牌号
	a.f_address, --地址
	u.f_userinfo_code, --用户编号
	u.f_user_name,  --用户姓名
	u.f_user_phone,
	h.f_tablebase, --本次抄表底数
	h.f_last_tablebase, --上期抄表底数
	h.f_oughtfee,  --应交金额
	h.f_oughtamount, --应交气量
	CONVERT(varchar(100), h.f_input_date, 23) f_input_date,  --录入日期
	isnull(sh.f_last_balance,0) f_balance, --上期实际结余
	h.f_hand_date, --下发日期
	case when (isnull(hh2.f_oughtfee,0) + isnull(hh2.overdue,0) + h.f_oughtfee - isnull(sh.f_debt_money,0)) < 0
	 then 0 else (isnull(hh2.f_oughtfee,0) + isnull(hh2.overdue,0) + h.f_oughtfee  - isnull(sh.f_debt_money,0)) end yinshou, --应收金额
	CONVERT(varchar(100), h.f_last_input_date, 23)  f_last_date, --上次录入日期
	isnull(hh2.overdue,0) overdue, --滞纳金
	u.f_balance f_curbalance, --本期实际结余
    CASE
        h.f_whether_pay
        WHEN '否' THEN
        '未收' ELSE '已收'
    END f_charge_state,
	isnull(convert(decimal(18,2),(hh2.f_oughtfee + hh2.overdue)),0) lswjd  --历史未交单
FROM
	t_handplan h
    LEFT JOIN (
       SELECT
            h.f_hand_id,shd.f_last_balance,SUM(f_debt_money) f_debt_money,
            SUM(f_charge_money) f_charge_money,SUM(f_overdue) f_selloverdue
          FROM t_sellinghand h left join (
			select f_hand_id,f_last_balance from t_sellinghand p where id = (select min(id) from t_sellinghand where f_hand_id=p.f_hand_id and f_state='有效' group by f_hand_id)
		  ) shd on h.f_hand_id = shd.f_hand_id
          WHERE f_state = '有效'
          GROUP BY h.f_hand_id,shd.f_last_balance
     ) sh on h.id = sh.f_hand_id
	LEFT JOIN t_userinfo u ON h.f_userinfo_id = u.f_userinfo_id
	LEFT JOIN t_userfiles f ON h.f_userfiles_id = f.f_userfiles_id
	LEFT JOIN t_user_address a ON f.f_useraddress_id = a.id
	--LEFT JOIN (	SELECT f_hand_id,sum(f_latefee_ought) f_latefee_ought FROM t_latefee_record WHERE f_state = '有效' GROUP BY f_hand_id) lf on lf.f_hand_id = h.id
	LEFT JOIN (
        SELECT
            f_userfiles_id,
            sum(ROUND(f_oughtfee-f_debt_money,2)) f_oughtfee,            --实际应交金额 convert(decimal(18,2),f_oughtfee-f_debt_money) ROUND(f_oughtfee-f_debt_money,2)
          --滞纳天数小于0，不计算滞纳金，返回0
            sum(convert(decimal(18,2),
            CASE WHEN overduedays<=0 THEN
                  0
            ELSE
                --滞纳金天数大于0，若应交金额小于0
                CASE WHEN overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -(case when f_balance<0 then 0 else f_balance end ))<0
                THEN
                  0
                ELSE
                  --判断应交金额是否小于0
                  (CASE WHEN overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -(case when f_balance<0 then 0 else f_balance end ))>=f_oughtfee-f_debt_money -(case when f_balance<0 then 0 else f_balance end )
                   THEN
                     CASE WHEN f_oughtfee-f_debt_money -f_balance<0
                     THEN 0
                     ELSE f_oughtfee-f_debt_money -f_balance
                     END
                   ELSE
                     overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -(case when f_balance<0 then 0 else f_balance end ))
                   END)
                END
            END)+f_latefee_ought) overdue
          FROM(
            SELECT
              id as handplan_id,
              f_oughtamount,
              f_oughtfee,
              isnull(f_debt_money,0) f_debt_money,
              isnull(f_charge_money,0) f_charge_money,
              isnull(f_selloverdue,0) f_selloverdue,
              isnull(f_remission_late_fee,0) f_remission_late_fee,
              h.f_end_date,
              h.f_userfiles_id,
              isnull(lr.f_latefee_ought,0) f_latefee_ought,
              u.f_balance,
              DATEDIFF(dd,f_end_date,getdate()) overduedays, --滞纳天数 sql server
              CASE WHEN h.f_user_type='民用'
              THEN isnull((SELECT cast(value as float) FROM  t_singlevalue WHERE name='民用违约金' and f_filialeids=u.f_orgid),(SELECT cast(value as float) FROM  t_singlevalue WHERE name='民用违约金'))
              ELSE
                isnull((SELECT cast(value as float) FROM  t_singlevalue WHERE name='非民用违约金' and f_filialeids=u.f_orgid),(SELECT cast(value as float) FROM  t_singlevalue WHERE name='非民用违约金'))
              END zhinajinbilv
            FROM t_handplan h
            LEFT JOIN (
              SELECT
                f_hand_id,SUM(f_debt_money) f_debt_money,
                SUM(f_charge_money) f_charge_money,SUM(f_overdue) f_selloverdue
              FROM t_sellinghand
              WHERE f_state = '有效'
              GROUP BY f_hand_id
            ) sh on h.id = sh.f_hand_id
            left join (
              select f_hand_id,sum(f_latefee_ought) f_latefee_ought
              from t_latefee_record where f_state='有效' group by f_hand_id
            ) lr on h.id = lr.f_hand_id
            LEFT JOIN t_userinfo u
                ON h.f_userinfo_id = u.f_userinfo_id
            left join t_userfiles uf on u.f_userinfo_id = uf.f_userinfo_id
            WHERE
              f_whether_pay='否' AND f_hand_state = '有效' and
              h.f_meter_state = '已抄表' AND f_oughtfee>0 and id not in (
                select max(id) from t_handplan where  f_whether_pay='否' AND f_hand_state = '有效' and
                    f_meter_state = '已抄表' AND f_oughtfee>0 group by f_userfiles_id
              )
          ) p group by f_userfiles_id
	)  hh2 on h.f_userfiles_id=hh2.f_userfiles_id
WHERE
	 {condition} and h.id IN ( SELECT MAX ( id ) FROM t_handplan h WHERE  f_hand_state = '有效' and
              h.f_meter_state = '已抄表'   GROUP BY f_userfiles_id )
ORDER BY
	u.f_userinfo_code
