//查询气表类型、用户类型
SELECT
	f_meter_type,
    f_user_type
FROM
	(
	SELECT
        CASE
			WHEN f_meter_type LIKE '%卡表%' THEN '卡表' ELSE f_meter_type
			END f_meter_type,
        s.f_user_type,
        s.f_gasproperties,
        sp.f_price_name,
        c.f_price_name + '(' + CAST ( c.f_price AS VARCHAR ) + ')' f_price,
        SUM ( c.f_gas ) f_gas,
        SUM ( f_money ) f_money
    FROM
        t_chargeprice c
        LEFT JOIN t_sellinggas s ON c.f_charge_id = s.ID
        LEFT JOIN t_stairprice sp ON s.f_stairprice_id = sp.ID
    WHERE
        f_charge_id IN ( SELECT ID FROM t_sellinggas s WHERE f_operate_date >= '{startDate}' AND f_operate_date <= '{endDate}' AND { f_orgid } AND s.f_state= '有效' )
    GROUP BY
        f_meter_type,
        s.f_user_type,
        s.f_gasproperties,
        sp.f_price_name,
        c.f_price_name,
        c.f_price
	) tt
GROUP BY
	f_meter_type,
	f_user_type
