select
		  f_operate_date f_operate_date,  --日期
		  SUM(case when f_type='发卡售气' then 1 else 0 end)  f_count_open, --发卡人数
		  SUM(case when f_type='发卡售气' then f_pregas else 0 end)  f_pregas_open, --发卡气量
		  SUM(case when f_type='发卡售气' then f_collection else 0 end)  f_collection_open, --发卡金额
		  SUM(case when f_type not in ('补卡','发卡售气','补气','换表')  then 1 else 0 end)  f_count_zg, --再够人数
		  SUM(case when f_type not in ('补卡','发卡售气','补气','换表')  then f_pregas else 0 end)  f_pregas_zg, --再够气量
		  SUM(case when f_type not in ('补卡','发卡售气','补气','换表')  then f_collection else 0 end)  f_collection_zg, --再够金额
		  COUNT(1) f_count,         --总次数
		  SUM(case when f_type<>'补气' then f_pregas else 0 end) f_pregas,         --总气量
		  SUM(case when f_type<>'补气' then f_collection else 0 end) f_collection       --总金额
 from (
	select
	left(convert(varchar,case when f_operator = '悦生活' then f_write_date else f_operate_date end,21),7) f_operate_date,
	f_type,
	f_zones,
	f_pregas,
	f_collection
	from
	t_sellinggas s
	where   f_state<>'无效' and isnull(f_write_card,'')<>'未写卡'
	and year(case when f_operator = '悦生活' then f_write_date else f_operate_date end)= '{YeadDate}'
	and {condition}  --传组织
	union all
	SELECT
		left(convert(varchar,f_operate_date,21),7) f_operate_date,
		'补卡' f_type,
		f_zones,
		0 f_pregas,
		f_cardfees f_collection
	FROM
		t_fillcard s
	where  f_state<>'无效'
	and year(f_operate_date)= '{YeadDate}'
	and {condition}
	union all
	SELECT
		left(convert(varchar,f_operate_date,21),7)f_operate_date,
		'换表' f_type,
		f_zones,
		0 f_pregas,
		f_changemeter_fee f_collection
	FROM
		t_changetables s
	where  f_state<>'无效'
	and year(f_operate_date)= '{YeadDate}'
	and {condition}
	union all
	SELECT
		left(convert(varchar,case when f_operator = '悦生活' then f_write_date else f_operate_date end,21),7) f_operate_date,
		'补气'  f_type,
		f_zones,
		f_pregas  f_pregas,
		f_preamount  f_collection
	FROM
		t_fillgas s
	where f_state<>'无效'
	and year(case when f_operator = '悦生活' then f_write_date else f_operate_date end)= '{YeadDate}'
	and {condition}
) xx group by f_operate_date order by f_operate_date
