select * from (
  select
    u.*,
    address.f_slice_area as f_zones,
    address.f_address,
    address.f_street,
    address.f_residential_area,
    address.f_building,
    address.f_unit,
    address.f_floor,
    address.f_room,
    info.f_userinfo_code,
    info.f_user_name,
    info.f_user_phone,
    info.f_user_state,
    info.f_idnumber idnumber,
    info.f_balance,
    adju.f_adjustable_name,
    adju.f_adjustable_id  adjustable_id,
    gb.f_meter_brand,
    gb.f_manufacturers,
    gm.f_meter_style,
	stair.value,
    sp.f_price_type,
    sp.f_price_name,
    case when  d.num>0 then '是' else '否' END isbgl
   from
  t_userfiles u
  left join t_user_address address
    on u.f_useraddress_id = address.id
  left join t_adjustablebox adju
    on u.f_adjustable_id = adju.id
  left join t_userinfo info
    on u.f_userinfo_id = info.f_userinfo_id
  left join t_gasbrand gb
    on u.f_gasbrand_id = gb.id
  left join t_gasmodel gm
    on u.f_gasmodel_id = gm.id
  left join t_stairprice sp
    on u.f_price_id = sp.f_price_id and u.f_filialeid = sp.f_filialeid and sp.f_state = '有效' and getdate()>=f_perform_date and getdate()<= sp.f_end_date
  left join (
          select s.id,
         s.f_price_type + (select ' ' + d.f_price_name + '阶:' + '单价' + cast(f_price as varchar) + ',上限' + cast(f_gas as varchar)
         from t_detailprice d where d.f_stairprice_id=s.id for xml path('')) value
         from t_stairprice s where s.f_state='有效' and getdate()>=f_perform_date and getdate()<=f_end_date
         group by s.id,s.f_price_type
  ) stair on stair.id=sp.id
  left join (
        select f_userfiles_id,count (*)num from t_devices where f_state='有效' and f_devices_type='壁挂炉' GROUP BY f_userfiles_id
         ) d on d.f_userfiles_id=u.f_userfiles_id
) t
where {condition} and f_table_state in ('正常', '待开通')
order by f_user_id,f_table_state desc
