SELECT
	*
FROM
	(
		SELECT
			t.*, f.f_userinfo_id
		FROM
			(
				SELECT
					f_user_id,
					f_userfiles_id,
					f_pregas AS gas,
					f_preamount AS fee,
					f_type AS type,
					f_operator,
					f_orgid,
					f_operate_date AS f_operate_date,
					isnull(f_comments, '') AS note
				FROM
					t_sellinggas
				WHERE
					f_state != '无效'
				UNION ALL
					SELECT
						f_user_id,
						f_userfiles_id,
						0 AS gas,
						f_cardfees AS fee,
						'补卡' AS type,
						f_operator,
						f_orgid,
						f_operate_date AS f_operate_date,
						f_ispick_table + ' ' + f_comments AS note
					FROM
						t_fillcard
					UNION ALL
						SELECT
							f_user_id,
							f_userfiles_id,
							isnull(f_pregas, 0) AS gas,
							isnull(f_preamount, 0) AS fee,
							f_type AS type,
							f_operator,
							f_orgid,
							f_operate_date AS f_operate_date,
							f_comments AS note
						FROM
							t_fillgas
						UNION ALL
							SELECT
								f_user_id,
								f_userfiles_id,
								0 AS gas,
								f_changemeter_fee AS fee,
								'换表' AS type,
								f_operator,
								f_orgid,
								f_changemeter_date AS f_operate_date,
								f_othereason AS note
							FROM
								t_changemeter
			) t
		LEFT JOIN (
			SELECT
				f_userinfo_id,
				f_user_id
			FROM
				t_userfiles
		) f ON t.f_user_id = f.f_user_id
	)s
where {condition}
order by f_operate_date desc
