SELECT
	f_operator,
	SUM ( f_yucun ) f_yucun,
	SUM ( f_oughtfee ) f_oughtfee,
	SUM ( f_cal_collection ) f_cal_collection,
	SUM ( f_collection ) f_collection,
	SUM ( f_other_fee ) f_other_fee,
	COUNT ( * ) f_number,
	ISNULL( SUM ( CASE WHEN f_collection < 0 THEN ISNULL( f_collection, 0 ) END ), 0 ) tuifei_fee,
	COUNT ( CASE WHEN f_collection < 0 THEN f_collection END ) tuifei_num,
	ISNULL( SUM ( CASE WHEN f_collection > 0 AND f_type LIKE '%预存%' THEN ISNULL( f_collection, 0 ) END ), 0 ) yucun_fee,
	COUNT ( CASE WHEN f_collection > 0 AND f_type LIKE '%预存%' THEN f_collection END ) yucun_num,
	ISNULL( SUM ( CASE WHEN f_collection > 0 AND f_type NOT LIKE '%预存%' THEN ISNULL( f_preamount, 0 ) END ), 0 ) qifei_fee,
	COUNT ( CASE WHEN f_collection > 0 AND f_type NOT LIKE '%预存%' THEN f_preamount END ) qifei_num,
	ISNULL( SUM ( f_collection ) + SUM ( f_other_fee ), 0 ) f_heji 
FROM
	(
	SELECT
		tss.f_operator,--
		tss.f_operate_date,
		tss.f_user_type,
		tss.f_gasproperties,
		gb.f_meter_brand,
		tss.f_meter_type,
		tss.f_payment,
		CASE WHEN tss.f_state= '有效' THEN isnull( tsd.sum_f_charge_money, 0 ) ELSE 0 
		END f_yucun,
CASE
	
	WHEN tss.f_state= '有效' THEN
	isnull( otsd.sum_not_charge_money, 0 ) ELSE 0 
	END f_oughtfee,
CASE
	
	WHEN tss.f_state!= '有效' THEN
	f_collection ELSE 0 
	END f_cal_collection,
	f_collection,
	0 f_other_fee,
	tss.f_orgid,
	tss.f_depid,
	tss.f_operatorid,
	td.f_type,
	tss.f_preamount 
FROM
	t_sellinggas tss
	LEFT JOIN ( SELECT f_userfiles_id, f_gasbrand_id FROM t_userfiles ) uf ON tss.f_userfiles_id= uf.f_userfiles_id
	LEFT JOIN ( SELECT id, f_meter_brand FROM t_gasbrand ) gb ON uf.f_gasbrand_id= gb.id
	LEFT JOIN ( SELECT f_sell_id, SUM ( f_charge_money ) 'sum_f_charge_money' FROM t_sellinghand GROUP BY f_sell_id, f_type HAVING f_type = '预存款' ) tsd ON tss.id = tsd.f_sell_id
	LEFT JOIN ( SELECT f_sell_id, SUM ( f_charge_money ) 'sum_not_charge_money' FROM t_sellinghand GROUP BY f_sell_id, f_type HAVING f_type <> '预存款' ) otsd ON tss.id = otsd.f_sell_id
	LEFT JOIN t_sellinghand td ON tss.id= td.f_sell_id UNION ALL
SELECT
	o.f_operator,
	o.f_operate_date,
	f_user_type,
	f_gasproperties,
	f_meter_brand,
	f_meter_type,
	o.f_payment,
	0 f_yucun,
	0 f_oughtfee,
	0 f_cal_collection,
	0 f_collection,
	f_collection f_other_fee,
	o.f_orgid,
	o.f_depid,
	o.f_operatorid,
	'' f_type,
	0 f_preamount 
FROM
	t_othercharge o
	LEFT JOIN ( SELECT f_userinfo_id, f_gasbrand_id, f_user_type, f_gasproperties FROM t_userfiles ) uf ON o.f_userinfo_id= uf.f_userinfo_id
	LEFT JOIN ( SELECT id, f_meter_brand, f_meter_type FROM t_gasbrand ) gb ON uf.f_gasbrand_id= gb.id 
WHERE
	o.f_state= '有效' 
	) s 
WHERE
	{ condition } 
GROUP BY
	f_operator
