select
	f_inputtor, --抄表员
	count(distinct uf_userinfo_id) f_user_number,--应抄户数
	sum(f_no_hand) f_no_hand,--未抄户数
	count(distinct f_out_hand) f_out_hand,--已抄无用量
	count(distinct uf_userinfo_id)-sum(f_no_hand) f_hand_num,--实抄户数
	cast(Convert(decimal(18,2),(count(distinct uf_userinfo_id)-sum(f_no_hand))/cast(case when count(distinct uf_userinfo_id)=0 then 1 else count(distinct uf_userinfo_id) end as float)*100) as varchar)+'%' f_hand_lv,--抄表率
	sum(f_oughtamount) f_oughtamount,--期间抄表气量
	sum(f_oughtfee) f_oughtfee,--期间抄表金额
	sum(f_debt_money) f_debt_money, --期间实收气费金额
	count(distinct f_sell_hand) f_sell_hand,--已收户数
	cast(Convert(decimal(18,2),count(distinct f_sell_hand)/cast(case when count(distinct uf_userinfo_id)-sum(f_no_hand)=0 then 1 else count(distinct uf_userinfo_id)-sum(f_no_hand) end as float)*100) as varchar)+'%' f_sell_lv--收费率
from (
	select
	 uf.f_userinfo_id uf_userinfo_id,
	 case when h.f_userinfo_id is null then 1 else 0 end f_no_hand,
	 case when h.f_oughtamount=0 then h.f_userinfo_id else null end f_out_hand,
	 case when h.f_whether_pay='是' then h.f_userinfo_id else null end f_sell_hand,
	 h.f_inputtor,
	 h.f_hand_date,
	 mb.f_book_name,
	 uf.f_user_type,
	 uf.f_gasproperties,
	 h.f_meter_classify,
	 h.f_whether_pay,
	 h.f_oughtamount,
	 h.f_oughtfee,
	 sh.f_charge_money,
	 sh.f_debt_money,
	 h.f_orgid
	from
	t_userfiles uf
	left join t_meter_book mb on uf.f_meter_book_num = mb.id
	left join t_user_address ua on uf.f_useraddress_id = ua.id
	left join t_handplan h on h.f_userfiles_id = uf.f_userfiles_id
	left join (
		select
			f_hand_id,
			sum(f_charge_money) f_charge_money,
			sum(f_debt_money) f_debt_money
		from t_sellinghand where f_state='有效' group by f_hand_id
	) sh on h.id = sh.f_hand_id
	where {condition} and f_hand_state='有效' and h.f_meter_state='已抄表'
	and uf.f_meter_classify='机表' and h.f_meter_classify='机表' and uf.f_table_state='正常'
) s group by f_inputtor
