

select
	f_residential_area,    --小区名称
	count(*) f_user_number,	--用户数

	sum(f_zhengchang) f_zhengchang,
	sum(f_tingyong) f_tingyong,
	sum(f_daikaitong) f_daikaitong,
	sum(f_yichang) f_yichang,


	sum(f_jibiao) f_jibiao, --期间抄表户数
	sum(f_oughtamount) f_oughtamount,
	sum(f_oughtfee) f_oughtfee,
    sum(f_collection_hand) f_collection_hand,	--期间缴费金额

	sum(f_wulian) f_wulian,	--物联网表用户数
	sum(f_oughtamount_web) f_oughtamount_web,
	sum(f_oughtfee_web) f_oughtfee_web,
    sum(f_collection_web) f_collection_web,	--期间缴费金额

	sum(f_kabiao) f_kabiao,		--卡表用户数
	sum(f_pregas) f_pregas,     --期间购气量
	sum(f_preamount) f_preamount,	--期间购气金额
	sum(f_collection_card) f_collection_card,	--期间实收金额

	sum(f_collection) f_collection	--期间实收金额
from(
	select
	 address.f_residential_area,
	 uf.f_userfiles_id,
	 u.f_user_name,
	 u.f_userinfo_code,
	 u.f_createfile_date,
	 uf.f_table_state,
	 u.f_user_state,
	 uf.f_meter_classify,
	 uf.f_user_type,
     uf.f_gasproperties,
	 case when uf.f_table_state='正常' and u.f_user_state='正常' then 1 else 0 end f_zhengchang,
	 case when uf.f_table_state='停用' and u.f_user_state='正常' then 1 else 0 end f_tingyong,
	 case when uf.f_table_state='待开通' and u.f_user_state='正常' then 1 else 0 end f_daikaitong,
	 case when  u.f_user_state!='正常' then 1 else 0 end f_yichang,

	 case when uf.f_meter_classify='机表' and h.f_userfiles_id is not null then 1 else 0 end f_jibiao,
	 case when uf.f_meter_classify='机表' then isnull(f_oughtamount,0) else 0 end f_oughtamount,
	 case when uf.f_meter_classify='机表' then isnull(f_oughtfee,0) else 0 end f_oughtfee,
	 case when uf.f_meter_classify='机表' then isnull(s.f_collection,0) else 0 end f_collection_hand,


	 case when uf.f_meter_classify='物联网表' and h.f_userfiles_id is not null then 1 else 0 end f_wulian,
	 case when uf.f_meter_classify='物联网表' then isnull(f_oughtamount,0) else 0 end f_oughtamount_web,
	 case when uf.f_meter_classify='物联网表' then isnull(f_oughtfee,0) else 0 end f_oughtfee_web,
	 case when uf.f_meter_classify='物联网表' then isnull(s.f_collection,0) else 0 end f_collection_web,

	 case when uf.f_meter_classify like '%卡表' and s.f_userfiles_id is not null then 1 else 0 end f_kabiao,
	 case when uf.f_meter_classify like '%卡表' then isnull(s.f_pregas,0) else 0 end f_pregas,
	 case when uf.f_meter_classify like '%卡表' then isnull(s.f_preamount,0) else 0 end f_preamount,
	 case when uf.f_meter_classify like '%卡表' then isnull(s.f_collection,0) else 0 end f_collection_card,

     isnull(s.f_collection,0) f_collection,
	 uf.f_depid,
	 uf.f_orgid,
	 uf.f_operatorid,
	 address.f_pcd_id
	from t_userfiles uf
	left join
	t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id
	left join
	t_user_address address
	on uf.f_useraddress_id = address.id
	left join (
		select
			f_userfiles_id,
			sum(f_oughtamount) f_oughtamount,
			sum(f_oughtfee) f_oughtfee
		from t_handplan
		where f_meter_state='已抄表' and f_hand_state='有效' and f_hand_date>='{startDate}' and f_hand_date<='{endDate}'
		group by f_userfiles_id
	) h on uf.f_userfiles_id = h.f_userfiles_id
	left join (
		select
			f_userfiles_id,
			sum(f_pregas) f_pregas,
			sum(f_preamount) f_preamount,
			sum(f_collection) f_collection
		from t_sellinggas where f_state='有效' and  f_operate_date>='{startDate}' and f_operate_date<='{endDate}'
		group by f_userfiles_id
	) s on uf.f_userfiles_id = s.f_userfiles_id
	where uf.f_table_state  = '正常' or uf.f_table_state='待开通' or uf.f_table_state='停用'
) a where {condition}
group by f_residential_area