SELECT
	tt.f_userinfo_id,
	tt.f_userinfo_code,
	tt.f_user_name,
	'抄表' f_type,
	stuff((SELECT distinct
      '/' +CAST(tm.f_price as VARCHAR(100))
   FROM (
			select
				n.f_userinfo_id,
				tde.f_price,
				n.f_user_type,
                n.f_gasproperties,
                n.f_orgid
			from t_handplan n
			join
				t_stairprice te
			ON
				n.f_price_id=te.f_price_id
			join
				t_detailprice tde
			on
				tde.f_stairprice_id=te.id
			where
				n.f_meter_state='已抄表'
				and n.f_hand_state='有效'
				and { condition }
			) tm
   WHERE tm.f_userinfo_id = tt.f_userinfo_id
   FOR XML PATH('')
   ),1,1,'') f_price,
	SUM(tt.f_oughtamount) f_oughtamount,
	SUM(tt.f_oughtfee) f_oughtfee,
	tt.f_whether_pay,
	tt.f_hand_date
from(
select
	n.f_userinfo_id,
	n.f_userinfo_code,
	n.f_user_name,
	tde.f_price,
	f_oughtamount,
	f_oughtfee,
	n.f_whether_pay,
	n.f_user_type,
	n.f_gasproperties,
	n.f_orgid,
	CONVERT(varchar(100), n.f_hand_date, 111) f_hand_date
from t_handplan n
join
	t_stairprice te
ON
	n.f_price_id=te.f_price_id
join
	t_detailprice tde
on
	tde.f_stairprice_id=te.id
where
	n.f_meter_state='已抄表'
	and n.f_hand_state='有效'
	and { condition }
) tt
GROUP BY
	tt.f_userinfo_id,
	tt.f_userinfo_code,
	tt.f_user_name,
	tt.f_whether_pay,
	tt.f_hand_date