SELECT
	tt.f_userinfo_code,
	tt.f_user_name,
	(SELECT TOP 1 f_last_balance FROM t_sellinghand WHERE f_userinfo_id = tt.f_userinfo_id  ) f_balance,
	SUM ( tt.f_oughtfee ) f_oughtfee,
	SUM ( tt.f_collection ) f_collection,
	( SELECT f_balance FROM t_sellinghand WHERE f_userinfo_id = tt.f_userinfo_id AND id = MAX ( tt.id )  ) f_last_balance,
	SUM ( tt.f_balances ) f_balances
FROM
	(
	SELECT
		d.id,
		d.f_userinfo_id,
		fe.f_userinfo_code,
		fe.f_user_name,
		fe.f_orgid,
		d.f_operate_date,
		tf.f_user_state,
		fe.f_gasproperties,
		fe.f_user_type,
		d.f_balance,
		fe.f_oughtfee,
		s.f_collection,
		d.f_last_balance,
		tf.f_balance f_balances
	FROM
		t_sellinghand d
		JOIN ( SELECT f_userinfo_id, f_oughtfee,f_user_type,f_gasproperties,f_userinfo_code,f_orgid,f_user_name FROM t_handplan WHERE f_meter_state = '已抄表' AND f_hand_state = '有效' and f_whether_pay='是') fe ON d.f_userinfo_id= fe.f_userinfo_id
		JOIN ( SELECT f_userinfo_id, f_collection FROM t_sellinggas WHERE f_meter_type = '机表' AND f_state = '有效' ) s ON d.f_userinfo_id= s.f_userinfo_id
		JOIN t_userinfo tf ON d.f_userinfo_id= tf.f_userinfo_id
	) tt
WHERE
	{ condition }
GROUP BY
	f_userinfo_id,
	tt.f_userinfo_code,
	tt.f_user_name