SELECT
	ts.f_month,
	SUM(ts.f_last_balance) f_last_balance,
	SUM(ts.f_money_pay) f_money_pay,
	SUM(ts.f_wechat_pay) f_wechat_pay,
	SUM(ts.f_bank_pay) f_bank_pay,
	SUM(ts.f_money_pay+ts.f_wechat_pay+ts.f_bank_pay) f_sum_pay,
	SUM(ts.f_pre_deduct_money) f_pre_deduct_money,
	SUM(ts.f_balance) f_balance
from(
SELECT
	DatePart( Mm, s.f_operate_date ) f_month,
	(SELECT f_last_balance FROM t_sellinghand where id=min(d.id) AND f_userinfo_id=d.f_userinfo_id) f_last_balance,
	ISNULL( SUM ( CASE s.f_payment WHEN '现金缴费' THEN s.f_preamount END ), 0 ) f_money_pay,
	ISNULL( SUM ( CASE s.f_payment WHEN '微信支付' THEN s.f_preamount END ), 0 ) f_wechat_pay,
	ISNULL( SUM ( CASE s.f_payment WHEN '银行转账' THEN s.f_preamount END ), 0 ) f_bank_pay,
	SUM(d.f_debt_money) f_pre_deduct_money,
	(SELECT f_balance FROM t_sellinghand where id=max(d.id) AND f_userinfo_id=d.f_userinfo_id) f_balance
FROM
t_sellinggas s
JOIN
t_sellinghand d
ON
s.id=d.f_sell_id
WHERE
	s.f_state = '有效'
	AND d.f_state='有效'
	AND s.f_meter_type='机表'
	AND s.f_operate_date>='{ startDate }'
	AND s.f_operate_date<='{ endDate }'
	AND  exists(select f_userinfo_id from t_userinfo tf where {condition} and s.f_userinfo_id=tf.f_userinfo_id )
GROUP BY
	DatePart( Mm, s.f_operate_date ),d.f_userinfo_id
) ts
GROUP BY
	ts.f_month
ORDER BY ts.f_month