SELECT
	SUBSTRING(s.f_month,LEN(s.f_month)-1,2) f_month,
	f_orgname,
	s.f_my_num,
	s.f_sy_num,
	s.f_gy_num,
	s.f_jt_num,
	(s.f_my_num+s.f_sy_num+s.f_gy_num+s.f_jt_num) f_sum_num,
	s.f_my_gas,
	s.f_sy_gas,
	s.f_gy_gas,
	s.f_jt_gas,
	(s.f_my_gas+s.f_sy_gas+s.f_gy_gas+s.f_jt_gas) f_sum_gas,
	s.f_my_account,
	s.f_sy_account,
	s.f_gy_account,
	s.f_jt_account,
	(s.f_my_account+s.f_sy_account+s.f_gy_account+s.f_jt_account) f_sum_account
 FROM
 (
 SELECT
	CONVERT(VARCHAR,DatePart (Yy,th.f_hand_date))+'0'+CONVERT(VARCHAR,DatePart (Mm,th.f_hand_date)) f_month,
	f_orgname,
	ISNULL(COUNT(CASE th.f_gasproperties WHEN '居民用气' THEN th.f_gasproperties END), 0) f_my_num,
	ISNULL(COUNT(CASE th.f_gasproperties WHEN '商业用气' THEN th.f_gasproperties END), 0) f_sy_num,
	ISNULL(COUNT(CASE th.f_gasproperties WHEN '工业用气' THEN th.f_gasproperties END), 0) f_gy_num,
	ISNULL(COUNT(CASE th.f_gasproperties WHEN '集体用气' THEN th.f_gasproperties END), 0) f_jt_num,

	ISNULL(SUM(CASE th.f_gasproperties WHEN '居民用气' THEN th.f_oughtamount END), 0) f_my_gas,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '商业用气' THEN th.f_oughtamount END), 0) f_sy_gas,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '工业用气' THEN th.f_oughtamount END), 0) f_gy_gas,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '集体用气' THEN th.f_oughtamount END), 0) f_jt_gas,

	ISNULL(SUM(CASE th.f_gasproperties WHEN '居民用气' THEN th.f_oughtfee END), 0) f_my_account,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '商业用气' THEN th.f_oughtfee END), 0) f_sy_account,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '工业用气' THEN th.f_oughtfee END), 0) f_gy_account,
	ISNULL(SUM(CASE th.f_gasproperties WHEN '集体用气' THEN th.f_oughtfee END), 0) f_jt_account
 FROM
		t_handplan th
	WHERE
		th.f_hand_state='有效'
		AND {condition}
 GROUP BY
	CONVERT(VARCHAR,DatePart (Yy,th.f_hand_date))+'0'+CONVERT(VARCHAR,DatePart (Mm,th.f_hand_date)),
	f_orgname
 ) s
 ORDER BY s.f_month