SELECT
	*
FROM
	(
		SELECT
		    u2.f_userinfo_id,
			u2.f_userinfo_code,
			u2.f_user_name,
			u1.f_user_type,
			u2.f_user_state,
			u2.f_user_phone,
			u1.f_gasproperties,
			u1.f_depname,
			u1.f_depid,
			u1.f_operatorid,
			u1.f_operator,
			u1.f_meternumber,
			u1.f_open_date,
			u3.f_address,
			u4.f_meter_type,
			u1.f_user_id,
			u1.f_userfiles_id,
			u1.f_table_state,
			u4.f_meter_brand,
			u8.f_price_name,
			datediff(
				DAY,
				isnull(
					u5.delivery_date,
					u1.f_input_date
				),
				GETDATE()
			) diffday,
			isnull(
				u5.delivery_date,
				u1.f_input_date
			) delivery_date,
			isnull(u5.cishu, 0) cishu,
			isnull(u5.pregas, 0) pregas,
				 isnull(u6.sellcishu,0) sellcishu,
				 isnull(u6.sellpregas,0) sellpregas,
			u1.f_orgid,
			u1.f_orgname
		FROM
			 (
			SELECT
				f_userfiles_id,
				COUNT (1) cishu,
				SUM (f_oughtamount) pregas,
				MAX (f_input_date) delivery_date
			FROM
				t_handplan
			WHERE
				f_meter_state = '已抄表'
			AND f_hand_state = '有效'
			GROUP BY
				f_userfiles_id
		) u5
  LEFT JOIN t_userfiles u1 ON u1.f_userfiles_id = u5.f_userfiles_id
		LEFT JOIN t_userinfo u2 ON u1.f_userinfo_id = u2.f_userinfo_id
		LEFT JOIN t_user_address u3 ON u1.f_useraddress_id = u3.id
		LEFT JOIN t_gasbrand u4 ON u1.f_gasbrand_id = u4.id
		LEFT JOIN (
			SELECT
				*
			FROM
				t_stairprice
			WHERE
				getdate() >= f_perform_date
			AND getdate() <= f_end_date
			AND f_state = '有效'
		) u8 ON u1.f_price_id = u8.f_price_id

		left join
			(
				select f_userfiles_id,COUNT(1) sellcishu,SUM(f_oughtamount) sellpregas from t_handplan
				where f_meter_state = '已抄表'
			    AND f_hand_state = '有效'
       and  f_input_date between {startDate} and {endDate}
				group by f_userfiles_id
			) u6
		on u1.f_userfiles_id=u6.f_userfiles_id
    where u4.f_meter_type = '机表'
	)ss
WHERE
	{condition}
ORDER BY
	f_userfiles_id
