SELECT
*
FROM
(
SELECT
	f_userinfo_id,
	f_userinfo_code,
	f_meternumber,
	f_user_name,
	f_address,
	f_user_type,
	f_gasproperties,
	f_table_state,
	f_meter_brand,
	SUM(f_oughtamount) f_oughtamount,
	SUM(f_oughtfee) f_oughtfee,
	MAX(end_time) end_time,
	0 qianfei_month_num,
	0 qianfei_num,
	0 qianfei_avg_gas,
	0 f_totalowe_gas,
	0 f_totalowe_fee
FROM
(
SELECT
	th.f_userinfo_id,

	tu.f_userinfo_code,
	tu.f_meternumber,
	tu.f_user_name,
	th.f_address,
	th.f_user_type,
	th.f_gasproperties,
	tu.f_table_state,
	f_meter_brand,
	sum(f_oughtamount) f_oughtamount,
	SUM(f_oughtfee) f_oughtfee,
	MAX(f_hand_date) end_time,
	convert(VARCHAR,DATEPART(Yy, GETDATE()))+convert(VARCHAR,DATEPART(Mm, GETDATE())) f_hand_date
from
	(
	    select * from t_handplan where {condition}
	) th
JOIN
	(
		SELECT
			tt.f_userinfo_id,
			tt.f_userinfo_code,
			f_table_state,
			tf.f_meternumber,
			tt.f_user_name
		from t_userinfo tt
		JOIN t_userfiles tf
		ON tt.f_userinfo_id=tf.f_userinfo_id
		where
			tt.f_user_state='正常'
			AND tf.f_table_state='正常'

	) tu
ON th.f_userinfo_id=tu.f_userinfo_id
where
	f_hand_date>={startDate}
	and f_hand_date<={endDate}
	AND f_hand_state='有效'
	AND f_meter_state='已抄表'
GROUP BY
	th.f_userinfo_id,
	tu.f_userinfo_code,
	tu.f_meternumber,
	tu.f_user_name,
	th.f_address,
	th.f_user_type,
	th.f_gasproperties,
	tu.f_table_state,
	th.f_meter_brand,
	convert(VARCHAR,DATEPART(Yy,f_hand_date))+convert(VARCHAR,DATEPART(Mm, f_hand_date))
) ts
GROUP BY
	f_userinfo_id,
	f_userinfo_code,
	f_meternumber,
	f_user_name,
	f_address,
	f_user_type,
	f_gasproperties,
	f_table_state,
	f_meter_brand
UNION ALL
SELECT
	f_userinfo_id,
	f_userinfo_code,
	f_meternumber,
	f_user_name,
	f_address,
	f_user_type,
	f_gasproperties,
	f_table_state,
	f_meter_brand,
	0 f_oughtamount,
	0 f_oughtfee,
	convert(DATE,null) end_time,
	COUNT(f_hand_date) qianfei_month_num,
	SUM(qianfei_num) qianfei_num,
	Convert(decimal(18,2),AVG(f_totalowe_gas)) qianfei_avg_gas,
	SUM(f_totalowe_gas) f_totalowe_gas,
	SUM(f_totalowe_fee) f_totalowe_fee
FROM
(
SELECT
	th.f_userinfo_id,
	tu.f_userinfo_code,
	tu.f_meternumber,
	tu.f_user_name,
	th.f_address,
	th.f_user_type,
	th.f_gasproperties,
	tu.f_table_state,
	th.f_meter_brand,
	convert(VARCHAR,DATEPART(Yy, GETDATE()))+convert(VARCHAR,DATEPART(Mm, GETDATE())) f_hand_date,
	COUNT(*) qianfei_num,
	SUM(f_totalowe_gas) f_totalowe_gas,
	SUM(f_totalowe_fee) f_totalowe_fee
from
	(
	    select * from t_handplan where {condition}
	) th
JOIN
	(
		SELECT
			tt.f_userinfo_id,
			tt.f_userinfo_code,
			f_table_state,
			tf.f_meternumber,
			tt.f_user_name
		from t_userinfo tt
		JOIN t_userfiles tf
		ON tt.f_userinfo_id=tf.f_userinfo_id
		where
			tt.f_user_state='正常'
			AND tf.f_table_state='正常'
	) tu
ON th.f_userinfo_id=tu.f_userinfo_id
where
	f_hand_date>={startDate}
	AND f_hand_date<={endDate}
	AND f_hand_state='有效'
	AND f_meter_state='已抄表'
	AND f_totalowe_gas>0
GROUP BY
	th.f_userinfo_id,
	tu.f_userinfo_code,
	tu.f_meternumber,
	tu.f_user_name,
	f_address,
	f_user_type,
	f_gasproperties,
	tu.f_table_state,
	f_meter_brand,
	convert(VARCHAR,DATEPART(Yy,f_hand_date))+convert(VARCHAR,DATEPART(Mm, f_hand_date))
) ts
GROUP BY
	f_userinfo_id,
	f_userinfo_code,
	f_meternumber,
	f_user_name,
	f_address,
	f_user_type,
	f_gasproperties,
	f_table_state,
	f_meter_brand
) tm
where
{mycondition}