/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Singleton;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class NewBuySubService {
    @Autowired
    public SessionFactory sessionFactory;
    private Session buySession;
    private Session handSession;
    private ScrollableResults buySet;
    private ScrollableResults handSet;
    private long buySetIndex;
    private final String BuySQL = "SELECT * FROM( SELECT f_user_id,convert(date,f_operate_date) f_operate_date,sum(f_pregas) f_pregas FROM t_sellinggas where  f_user_id !=10012380  and f_state= '\u6709\u6548' and f_user_id  not in (select ts.f_user_id from T_SELLINGGAS ts,T_HANDPLAN th where ts.f_user_id = th.f_user_id and f_type = '\u8d85\u7528\u6536\u8d39' group by ts.f_user_id )  GROUP BY f_user_id,f_operate_date ) t_gas ORDER BY f_user_id,f_operate_date";
    private final String HandSQL = "SELECT f_user_id,f_hand_date,f_tablebase FROM t_handplan where    f_user_id !=10012380    and f_user_id  not in (select ts.f_user_id from T_SELLINGGAS ts,T_HANDPLAN th where ts.f_user_id = th.f_user_id and f_type = '\u8d85\u7528\u6536\u8d39' group by ts.f_user_id )     ORDER BY f_user_id, f_hand_date";
    private long startDate;
    private long endDate;
    private long daysNumber = 0L;
    private double handSum = 0.0;
    private double buySum = 0.0;
    private Record handLastUser = null;
    private Record buyGasLastUser = null;
    private final long ONE_DAY_MSEC = 86400000L;
    private SimpleDateFormat si = new SimpleDateFormat("yyyy-MM-dd");
    private long handStartDate;
    private long handEndDate;
    private String tempUserid = "";
    int jishu = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFixedNum(double ratio, Date startDate, Date endDate) {
        double result;
        this.startDate = startDate.getTime();
        this.handStartDate = startDate.getTime();
        this.endDate = endDate.getTime();
        this.handEndDate = endDate.getTime();
        if (ratio == 0.0) {
            ratio = 1.0;
        }
        try {
            this.createScrollableResults();
            result = this.getFixedNum();
        }
        catch (Exception e) {
            e.printStackTrace();
            double d = 0.0;
            return d;
        }
        finally {
            this.destroyClassVariate();
        }
        return result * ratio;
    }

    private double getFixedNum() {
        this.daysNumber = (this.endDate - this.startDate) / this.ONE_DAY_MSEC;
        boolean isForLoop = true;
        while (isForLoop) {
            Record record = null;
            Record record2 = null;
            if (this.handLastUser == null) {
                record = new Record(this.handSet);
            } else {
                record = this.handLastUser;
                this.handLastUser = null;
            }
            if (record.isEnd) {
                record2 = new Record(record, this.handSet);
                if (record2.isEnd && record2.last != null) {
                    List<TimeAverage> times = this.scopeTime(record2, true);
                    this.compute(record2, times);
                    continue;
                }
                this.handLastUser = record2;
                continue;
            }
            isForLoop = false;
        }
        System.out.println("\u6284\u8868\u91cf:" + this.handSum + "\u65b9");
        System.out.println("\u8d2d\u6c14\u91cf:" + this.buySum + "\u65b9");
        System.out.println("\u67e5\u770b\u5230\u5e95\u591a\u5c11\u6761\u6709\u6548" + this.jishu);
        return new BigDecimal(this.handSum / this.buySum).setScale(6, 4).doubleValue();
    }

    private void compute(Record record, List<TimeAverage> hand) {
        String userid = record.userid;
        Record buyUser = null;
        if (this.handLastUser == null || !this.handLastUser.isEnd) {
            buyUser = new Record(this.buySet);
            if (buyUser.userid == null) {
                buyUser.userid = userid;
            }
        } else {
            buyUser = this.handLastUser;
            this.handLastUser = null;
        }
        if (!buyUser.userid.equals(userid)) {
            buyUser = this.getBuyGasUser(record, false);
        }
        buyUser = new Record(buyUser, false);
        if (buyUser.last != null && buyUser.isEnd) {
            List<TimeAverage> buy = this.scopeTime(buyUser, false);
            Iterator<TimeAverage> it = hand.iterator();
            if (hand.size() > 0 && buy.size() > 0) {
                while (it.hasNext()) {
                    if (it.next().endDate <= buy.get(buy.size() - 1).endDate) continue;
                    it.remove();
                }
            }
            if (hand.size() == 0 || buy.size() == 0) {
                return;
            }
            ++this.jishu;
            for (TimeAverage tem : hand) {
                System.out.println("\u6709\u6548\u7684\u6284\u8868\u503c" + tem.toString());
            }
            for (TimeAverage tep : buy) {
                System.out.println("\u6709\u6548\u7684\u8d2d\u6c14\u503c" + tep.toString());
            }
            this.handSum += this.sumGas(hand);
            this.buySum += this.sumGas(buy);
        }
    }

    private double sumGas(List<TimeAverage> items) {
        double sumValue = 0.0;
        long date = this.startDate;
        long day = 0L;
        int index = 0;
        items = this.mergeRepetition(items);
        TimeAverage item = null;
        while (index < items.size() && day <= this.daysNumber) {
            date = this.startDate + day * this.ONE_DAY_MSEC;
            item = items.get(index);
            if (item.startDate <= date && item.endDate >= date) {
                sumValue += item.getAverageValue();
                if (index + 1 >= items.size() || items.get(index + 1).endDate != date) {
                    ++day;
                    continue;
                }
                ++index;
                continue;
            }
            if (item.startDate > date) {
                ++day;
                continue;
            }
            ++index;
        }
        return sumValue;
    }

    private List<TimeAverage> mergeRepetition(List<TimeAverage> items) {
        if (items.size() == 1) {
            return items;
        }
        ArrayList<TimeAverage> rollBack = new ArrayList<TimeAverage>();
        TimeAverage item = items.get(0);
        for (int i = 1; i < items.size(); ++i) {
            if (!items.get(i).isValid()) continue;
            if (item.startDate == items.get(i).startDate && item.endDate == items.get(i).endDate) {
                double endValue;
                double startValue;
                if (item.type) {
                    startValue = item.startValue;
                    endValue = items.get(i).endValue;
                    item = new TimeAverage(item.startDate, item.endDate, item.userid, item.day, endValue - startValue, startValue, endValue, item.type);
                } else {
                    startValue = item.startValue;
                    endValue = items.get(i).startValue + items.get(i).endValue;
                    item = new TimeAverage(item.startDate, item.endDate, item.userid, item.day, startValue + endValue, startValue, endValue, item.type);
                }
                if (i + 1 != items.size()) continue;
                rollBack.add(item);
                continue;
            }
            rollBack.add(item);
            if (i == items.size() - 1) {
                rollBack.add(items.get(i));
                break;
            }
            item = items.get(i);
        }
        return rollBack;
    }

    private List<TimeAverage> scopeTime(Record record, boolean type) {
        ArrayList<TimeAverage> list = new ArrayList<TimeAverage>();
        String gc = "";
        int i = 0;
        if (!record.userid.equals(this.tempUserid)) {
            this.startDate = this.handStartDate;
            this.endDate = this.handEndDate;
            this.tempUserid = record.userid;
        }
        while (record.isEnd && record.last != null) {
            TimeAverage time = null;
            if (record.last.dateTime < this.startDate && record.dateTime > this.startDate && record.dateTime <= this.endDate) {
                ++i;
                time = new TimeAverage(record.last.dateTime, record.dateTime, record.userid, type, record.last.gasNum, record.gasNum);
            } else {
                if (record.last.dateTime < this.startDate && record.dateTime >= this.endDate) {
                    ++i;
                    time = new TimeAverage(record.last.dateTime, record.dateTime, record.userid, type, record.last.gasNum, record.gasNum);
                    list.add(time);
                    record = this.nextUser(record, type);
                    break;
                }
                if (record.last.dateTime >= this.startDate && record.last.dateTime < this.endDate) {
                    if (i == 0 && type) {
                        this.startDate = record.last.dateTime;
                        ++i;
                    }
                    time = new TimeAverage(record.last.dateTime, record.dateTime, record.userid, type, record.last.gasNum, record.gasNum);
                }
            }
            if (time != null) {
                list.add(time);
            }
            gc = type ? "\u6284\u8868" : "\u8d2d\u6c14";
            record = new Record(record, type ? this.handSet : this.buySet);
        }
        if (type) {
            this.handLastUser = record;
        } else {
            this.buyGasLastUser = record;
        }
        return list;
    }

    private Record nextUser(Record record, boolean type) {
        ScrollableResults scroll;
        String userid = record.userid;
        ScrollableResults scrollableResults = scroll = type ? this.handSet : this.buySet;
        while (record.isEnd && record.userid.equals(userid)) {
            record = new Record(record, scroll);
        }
        return record;
    }

    private Record getBuyGasUser(Record record, boolean type) {
        String userid = record.userid;
        ScrollableResults scroll = type ? this.handSet : this.buySet;
        do {
            record = new Record(record, scroll);
        } while (record.isEnd && !record.userid.equals(userid));
        return record;
    }

    private void createScrollableResults() {
        this.handSet = this.createScrollableResult(true, this.HandSQL);
        this.buySet = this.createScrollableResult(false, this.BuySQL);
    }

    private ScrollableResults createScrollableResult(boolean bol, String SQL) {
        Session session = this.sessionFactory.openSession();
        if (bol) {
            this.handSession = session;
        } else {
            this.buySession = session;
        }
        return session.createSQLQuery(SQL).scroll();
    }

    private void destroyClassVariate() {
        if (this.handSet != null) {
            this.handSet.close();
        }
        if (this.buySet != null) {
            this.buySet.close();
        }
        if (this.handSession != null) {
            this.handSession.close();
        }
        if (this.buySession != null) {
            this.buySession.close();
        }
    }

    public void junitTest() {
        Double dou = this.getFixedNum(1.0, new Date(1541952000000L), new Date(1543680000000L));
    }

    public static void main(String[] args) {
    }

    private class TimeAverage {
        private long startDate;
        private long endDate;
        private double startValue;
        private double endValue;
        private String userid;
        private long day;
        private double averageValue;
        public boolean type;

        public String toString() {
            return "TimeAverage{startDate=" + NewBuySubService.this.si.format(this.startDate) + ", endDate=" + NewBuySubService.this.si.format(this.endDate) + ", startValue=" + this.startValue + ", endValue=" + this.endValue + ", userid='" + this.userid + '\'' + ", day=" + this.day + ", averageValue=" + this.averageValue + ", type=" + this.type + ", isValid=" + this.isValid() + "}\n";
        }

        public TimeAverage(long startDate, long endDate, String userid, long day, double averageValue, double startValue, double endValue, boolean type) {
            this.setParam(startDate, endDate, userid, day, averageValue, startValue, endValue, type);
        }

        public TimeAverage(long startDate, long endDate, String userid, boolean type, double startNum, double endNum) {
            long days = (endDate - startDate) / 86400000L;
            if (days < 1L) {
                if (type) {
                    if (startNum <= endNum) {
                        this.setParam(startDate, endDate, userid, 0L, endNum - startNum, startNum, endNum, type);
                    }
                } else {
                    this.setParam(startDate, endDate, userid, 0L, startNum + endNum, startNum, endNum, type);
                }
            } else if (type) {
                if (startNum <= endNum) {
                    double average = (endNum - startNum) / (double)days;
                    this.setParam(startDate, endDate, userid, days, average, startNum, endNum, type);
                }
            } else {
                double average = startNum / (double)days;
                this.setParam(startDate, endDate, userid, days, average, startNum, endNum, type);
            }
        }

        private void setParam(long startDate, long endDate, String userid, long day, double averageValue, double startValue, double endValue, boolean type) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.userid = userid;
            this.day = day;
            this.averageValue = averageValue;
            this.type = type;
            this.startValue = startValue;
            this.endValue = endValue;
        }

        public long getStartDate() {
            return this.startDate;
        }

        public long getEndDate() {
            return this.endDate;
        }

        public String getUserid() {
            return this.userid;
        }

        public long getDay() {
            return this.day;
        }

        public double getAverageValue() {
            return this.averageValue;
        }

        public boolean isType() {
            return this.type;
        }

        public boolean isValid() {
            return !(this.averageValue < 0.0);
        }
    }

    private class Record {
        public String userid;
        public long dateTime;
        public double gasNum;
        public boolean type;
        public Record last;
        public boolean isEnd = false;

        public Record(ScrollableResults results) {
            this.getRecord(results);
        }

        public String toString() {
            return "Record{userid='" + this.userid + '\'' + ", dateTime=" + this.dateTime + ", gasNum=" + this.gasNum + ", type=" + this.type + ", last=" + this.last + ", isEnd=" + this.isEnd + '}';
        }

        public Record(Record record, boolean type) {
            record.last = null;
            this.getRecord(record, type ? NewBuySubService.this.handSet : NewBuySubService.this.buySet);
        }

        public Record(Record record, ScrollableResults results) {
            record.last = null;
            this.getRecord(record, results);
        }

        private void getRecord(Record record, ScrollableResults results) {
            if (record == null) {
                this.getRecord(results);
                return;
            }
            this.getRecord(results);
            if (this.isEnd && record.userid.equals(this.userid)) {
                this.last = record;
            }
        }

        private void getRecord(ScrollableResults results) {
            if (results == NewBuySubService.this.buySet) {
                this.type = false;
            } else if (results == NewBuySubService.this.handSet) {
                this.type = true;
            }
            this.setParam(this, results);
        }

        private void setParam(Record record, ScrollableResults results) {
            if (results.next()) {
                Object[] obj = results.get();
                if (obj[0] != null) {
                    record.userid = obj[0].toString();
                    if (obj[1] != null) {
                        record.dateTime = ((Date)obj[1]).getTime();
                        if (obj[2] != null) {
                            record.gasNum = ((BigDecimal)obj[2]).doubleValue();
                            record.isEnd = true;
                            if (results == NewBuySubService.this.buySet) {
                                if (NewBuySubService.this.buySetIndex % 100000L == 0L) {
                                    // empty if block
                                }
                                NewBuySubService.this.buySetIndex++;
                            }
                        }
                    }
                }
            } else {
                record.isEnd = false;
            }
        }
    }
}

