
SELECT ROW_NUMBER() OVER(ORDER BY fakeline desc) as idnumber,* FROM (
	SELECT
		
		case when (f_outlets is null and f_operator is null and f_gasproperties is null ) then '总计' 
			 when f_operator is null and f_gasproperties is null   then '小计' 
			 else f_outlets
		end as f_outlets,
		f_operator,
		f_gasproperties,
		COUNT(*) times,
		SUM(f_pregas) f_pregas,
		SUM (f_preamount) f_preamount,
		SUM (f_collection) f_collection,
		'' fakeline
	FROM
		(

			SELECT  
				f_gasproperties,f_operator,f_outlets,f_pregas,f_preamount,f_collection 
			FROM 
				t_sellinggas 
			WHERE 
				f_charge_state != '无效' and f_delivery_date >= '{startDate}' and f_delivery_date <= '{endDate}'
			
			UNION all
			
			SELECT  
				s2.f_gasproperties,s1.f_operator,s1.f_outlets,s1.f_correct_gas as f_pregas,s1.f_correct_money as f_preamount, s1.f_correct_collection as f_collection 
			FROM 
				t_correctrecord s1
			JOIN 
				t_sellinggas s2 
			ON 
				s1.f_correct_id=s2.id
			WHERE 
				s1.f_correct_state != '无效'  and s1.f_correct_date >= '{startDate}' and s1.f_correct_date <= '{endDate}'

		) t
	GROUP BY rollup(f_outlets,(f_operator,f_gasproperties))
) tt
ORDER BY fakeline
