select * from (
	SELECT
		h.id,
		h.f_balance,
		h.f_curbalance,
		h.f_oughtamount,
		h.f_share_gas,
		h.f_totalowe_fee,
		h.f_totalowe_gas,
		h.f_oughtfee,
		h.f_reduce_fee,
		h.f_tablebase,
		h.f_last_tablebase,
		h.f_surplus_gas,
		h.f_haircut_gas,
		h.f_inputtor,
		h.f_input_person,
		h.f_whether_pay,
		case when c.f_correct_id is not null  then '冲正' else h.f_meter_state end f_meter_state,
		h.f_recharge_state,
		h.f_meter_source,
		h.f_issued_state,
		h.f_operator,
		h.f_filiale,
		h.f_outlets,
		h.f_orgstr,
		h.f_filialeids,
		h.f_price_id,
		h.f_stairprice_id,
		h.f_sell_id,
		h.f_user_id,
		h.f_user_name,
		h.f_user_type,
		h.f_gasproperties,
		h.f_meterbook_number,
		h.f_userinfo_id,
		h.f_address,
		h.f_meter_brand,
		h.f_meter_style,
		h.f_meternumber,
		h.f_reverse_state,
		h.f_real_pregas,
		h.f_collector,
		h.f_overdue,
		h.f_meter_limit,
		h.f_upload,
		h.f_download,
		h.f_savehangid,
		h.f_mark,
		CONVERT (VARCHAR (100), h.f_hand_date, 23) AS f_hand_date,
		CONVERT (VARCHAR (100), h.f_input_date, 23) AS f_input_date,
		CONVERT (VARCHAR (100), h.f_audit_date, 23) AS f_audit_date,
		CONVERT (VARCHAR(100), h.f_end_date, 23) AS f_end_date,
		CONVERT (VARCHAR (100), h.f_sell_date, 23) AS f_sell_date,
		CONVERT (VARCHAR(100), h.f_old_date, 23) AS f_old_date,
		u.f_user_phone,
		u.f_residential_area,
		u.f_userinfo_code,
		c.f_operator as f_correct_operator,     -- 抄表冲正 人员
		CONVERT (VARCHAR(100), c.f_correct_date, 23) AS f_correct_date  -- 抄表冲正 日期
	FROM t_handplan h
	LEFT JOIN  t_userinfo u
	ON h.f_userinfo_id = u.f_userinfo_id
	LEFT JOIN t_correcthandplan c
	on c.f_correct_id = h.id
) handplan
WHERE
  {condition}
ORDER BY
  f_input_date desc