select 
	f_gasproperties_type,
	f_gasproperties,
	SUM(c) c,
	cast(SUM(f_gas) as numeric(19, 3)) f_pregas,
	cast(SUM(f_money) as numeric(19, 3)) f_preamount,
	cast(SUM(f_collection) as numeric(19, 3)) f_collection
from (
	select
		s1.f_price_id,
		s.f_gasproperties_type,
		s.f_gasproperties,
		SUM(c) c,
		SUM(f_gas1)+SUM(f_gas2)+SUM(f_gas3) f_gas,
		SUM(f_money1)+SUM(f_money2)+SUM(f_money3) f_money,
		0 f_collection
	from (	
		select 
			f_price_id,
			COUNT(distinct f_userinfo_id) c,
			SUM(f_gas1) f_gas1,
			SUM(f_money1) f_money1,
			SUM(f_gas2) f_gas2,
			SUM(f_money2) f_money2,
			SUM(f_gas3) f_gas3,
			SUM(f_money3) f_money3
		from(	
			select
				f_price_id,
				f_userinfo_id,
				case when f_price_name='阶梯1' or f_price_name='固定气价' then f_gas else 0 end f_gas1,
				case when f_price_name='阶梯1' or f_price_name='固定气价' then 
				(case when f_money=0 then f_gas*1.98 else f_money end) else 0 end f_money1,
				case when f_price_name='阶梯2' then f_gas else 0 end f_gas2,
				case when f_price_name='阶梯2' then (case when f_money=0 then f_gas*1.98 else f_money end) else 0 end f_money2,
				case when f_price_name='阶梯3' then f_gas else 0 end f_gas3,
				case when f_price_name='阶梯3' then (case when f_money=0 then f_gas*1.98 else f_money end) else 0 end f_money3
			from V_handplan h
			left join t_chargeprice c  on c.f_hand_id=h.id 
			where  h.f_sell_id in (
				select 
					id
				from t_sellinggas 
				where f_charge_state='有效' and f_delivery_date>='{startDate}'
					  and f_delivery_date<='{endDate}'
			) and f_hand_date<=DATEADD(ms,-3,DATEADD(mm, DATEDIFF(m,0,'{endDate}'), 0))
		) p group by f_price_id
	) s1 left join 
	(select * from t_stairprice where f_state='有效') s 
	on s1.f_price_id=s.f_price_id
	group by s1.f_price_id,s.f_gasproperties_type,s.f_gasproperties
	union all
	select 
		 s.f_price_id,
		c.f_gasproperties_type,
		c.f_gasproperties,
		0 c,
		0 f_gas,
		0 f_money,
		sum(f_collection-f_delaypay) f_collection
		 from(
	select s1.f_price_id,s1.f_userinfo_id,
	       s1.f_collection,s1.f_delaypay from (
	select f_userinfo_id,MAX(f_delivery_date) f_delivery_date from t_sellinggas
	where f_charge_state='有效' and f_delivery_date>='{startDate}'
		  and f_delivery_date<='{endDate}'
		  and id in (
		   select f_sell_id from V_handplan
		   where f_hand_date<'{startDate}' 
		         and f_meter_state='已抄表' and	f_whether_pay='是'
		  ) 
    group by f_userinfo_id
	) s
	left join
	(select f_userinfo_id,f_collection,f_price_id,f_delivery_date,f_delaypay from t_sellinggas
	 where f_charge_state='有效' and f_delivery_date>='{startDate}'
		  and f_delivery_date<='{endDate}'
	) s1 on s.f_userinfo_id=s1.f_userinfo_id and s1.f_delivery_date<=s.f_delivery_date
	) s
	left join
	(select * from t_stairprice where f_state='有效') c on s.f_price_id=c.f_price_id 
	group by  s.f_price_id,f_gasproperties_type,f_gasproperties
) s group by f_price_id,f_gasproperties_type,f_gasproperties