SELECT
	f_operate_date
FROM
	(
		--拿收费记录（不拿同一天冲正的记录）
		SELECT
			{ entity.findDialect () == $SqlServer$ : $CONVERT (
				VARCHAR (10),
				f_operate_date,
				120
			) $,
			$TO_CHAR (
				f_operate_date,
				'yyyy-mm-dd'
			) $ } f_operate_date,
			f_user_type,
			COUNT (ID) c,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_pregas), 0) f_pregas,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_preamount), 0) f_preamount,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(f_collection), 0) f_collection
		FROM
			t_sellinggas
		WHERE
			f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
			$to_date (
				'{startDate}',
				'yyyy-mm-dd hh24:mi:ss'
			) $ }
		AND f_operate_date <={ entity.findDialect () == $SqlServer$ : $ '{endDate}' $,
		$to_date (
			'{endDate}',
			'yyyy-mm-dd hh24:mi:ss'
		) $ }
	AND f_state != '无效'
AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
 f_filiale == $$ : $ 1 = 1 $,
 $$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
	AND ID NOT IN (
		SELECT
			f_correct_id
		FROM
			t_correctrecord
		WHERE
			f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
			$to_date (
				'{startDate}',
				'yyyy-mm-dd hh24:mi:ss'
			) $ }
		AND f_operate_date <= { entity.findDialect () == $SqlServer$ : $ '{endDate}' $,
		$to_date (
			'{endDate}',
			'yyyy-mm-dd hh24:mi:ss'
		) $ }
	AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
 f_filiale == $$ : $ 1 = 1 $,
 $$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
	)
	GROUP BY
		{ entity.findDialect () == $SqlServer$ : $CONVERT (
			VARCHAR (10),
			f_operate_date,
			120
		) $,
		$TO_CHAR (
			f_operate_date,
			'yyyy-mm-dd'
		) $ }, f_user_type
	UNION ALL
		--拿往期冲正金额
		SELECT
			{ entity.findDialect () == $SqlServer$ : $CONVERT (
				VARCHAR (10),
				u1.f_operate_date,
				120
			) $,
			$TO_CHAR (
				u1.f_operate_date,
				'yyyy-mm-dd'
			) $ } f_operate_date,
			u2.f_user_type,
			(0 - COUNT(*)) c,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(u1.f_correct_gas), 0) f_pregas,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (SUM(u1.f_correct_money), 0) f_preamount,
			{ entity.findDialect () == $SqlServer$ : $isnull$,
			$NVL$ } (
				SUM (u1.f_correct_collection),
				0
			) f_collection
		FROM
			(
				SELECT
					f_correct_id,
					f_operate_date,
					f_correct_gas,
					f_correct_money,
					f_correct_collection
				FROM
					t_correctrecord
				WHERE
					f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
					$to_date (
						'{startDate}',
						'yyyy-mm-dd hh24:mi:ss'
					) $ }
				AND f_operate_date <= { entity.findDialect () == $SqlServer$ : $ '{endDate}' $,
				$to_date (
					'{endDate}',
					'yyyy-mm-dd hh24:mi:ss'
				) $ }
			AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
 f_filiale == $$ : $ 1 = 1 $,
 $$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
			) u1
		LEFT JOIN (
			SELECT
				f_user_type,
				ID
			FROM
				t_sellinggas
			WHERE
				f_operate_date < { entity.findDialect () == $SqlServer$ : $ '{startDate}' $,
				$to_date (
					'{startDate}',
					'yyyy-mm-dd hh24:mi:ss'
				) $ }
			AND f_state != '无效'
		) u2 ON u1.f_correct_id = u2. ID
		WHERE
			u2. ID IS NOT NULL
		GROUP BY
			{ entity.findDialect () == $SqlServer$ : $CONVERT (
				VARCHAR (10),
				u1.f_operate_date,
				120
			) $,
			$TO_CHAR (
				u1.f_operate_date,
				'yyyy-mm-dd'
			) $ }, f_user_type
	) s
GROUP BY
	f_operate_date
ORDER BY
	f_operate_date