SELECT
	f_operate_date,
	f_price,
	SUM (F_GAS) f_gas,
	SUM (F_MONEY) f_money,
	COUNT (ID) c
FROM
	(
		SELECT
			*
		FROM
			(
				SELECT
					F_GAS,
					F_MONEY,
					F_PRICE,
					F_CHARGE_ID
				FROM
					T_CHARGEPRICE
				WHERE
					f_state = '有效'
				AND f_operate_date >= TO_DATE (
					'{startDate} 00:00:00',
					'yyyy-mm-dd hh24:mi:ss'
				)
				AND f_operate_date <= TO_DATE (
					'{endDate} 23:59:59',
					'yyyy-mm-dd hh24:mi:ss'
				)
				AND { f_price != $$ : $ f_price = '{f_price}' $,
 f_price == $$ : $ 1 = 1 $,
 $$ }
				AND F_MONEY != 0
			) ch
		LEFT JOIN (
			SELECT
				ID,
				TO_CHAR (
					f_operate_date,
					'yyyy-mm-dd'
				) AS f_operate_date
			FROM
				T_SELLINGGAS
			WHERE
				f_state = '有效'
			AND f_operate_date >= TO_DATE (
				'{startDate} 00:00:00',
				'yyyy-mm-dd hh24:mi:ss'
			)
			AND f_operate_date <= TO_DATE (
				'{endDate} 23:59:59',
				'yyyy-mm-dd hh24:mi:ss'
			)
			AND { condition }
		) ON ch.F_CHARGE_ID = ID
	) tt
WHERE
--防止收费记录条件选择后 没有数据
	f_operate_date IS NOT NULL
GROUP BY
	f_operate_date,
	F_PRICE
ORDER BY
	f_operate_date,
	F_PRICE